package com.duiba.tuia.youtui.web.tool;

import com.alibaba.fastjson.JSONObject;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by Administrator on 2017/12/13.
 */
public class SmsTool {

    private SmsTool() {
    }

    public static final String UTF_8 = "UTF-8";

    /**
     * sendCodeSms:(发送短信验证码). <br/>
     *
     * @param phone
     * @param text
     * @return
     * @throws
     * @author youhaijun
     * @since JDK 1.8
     */
    public static String sendCodeSms(String phone, String text) throws IOException {

        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPost post = new HttpPost("http://yunpian.com/v1/sms/send.json");
        List<NameValuePair> params = new ArrayList<>();
        params.add(new BasicNameValuePair("mobile", phone));
        params.add(new BasicNameValuePair("text", text));
        params.add(new BasicNameValuePair("apikey", "dd66615d922f2519ff134c0df909e505"));
        post.setEntity(new UrlEncodedFormEntity(params, UTF_8));
        CloseableHttpResponse response = client.execute(post);
        return EntityUtils.toString(response.getEntity());

    }

    /***
     * @Description: alertDingDing 调用shark平台钉钉告警
     *
     * @Param: [msg 告警内容, token 群机器人token]
     * @Return: java.lang.Boolean
     * @throws:
     * @author: youhaijun
     * @Date: 2017/12/21
     */
    public static String alertDingDing(String msg, String url) {
        try (CloseableHttpClient httpClient = HttpClients.createDefault()) {
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("Content-Type", "application/json; charset=utf-8");
            JSONObject param = new JSONObject();
            param.put("msgtype", "text");
            JSONObject text = new JSONObject();
            text.put("content", msg);
            param.put("text", text);
            JSONObject at = new JSONObject();
            String[] atMobile = new String[3];
            atMobile[0] = "18014749609";
            atMobile[1] = "13067823492";
            at.put("atMobiles", atMobile);
            at.put("isAtAll", false);
            param.put("at", at);
            StringEntity entity = new StringEntity(param.toJSONString(), UTF_8);
            httpPost.setEntity(entity);

            HttpResponse response = httpClient.execute(httpPost);
            if (response.getStatusLine().getStatusCode()== HttpStatus.SC_OK) {
                return EntityUtils.toString(response.getEntity(), UTF_8);
            }
            return "调用钉钉失败";
        } catch (IOException e) {
            return "调用钉钉失败";
        }
    }
}
