package com.duiba.tuia.youtui.web.service.impl;

import cn.com.duiba.tuia.activity.center.api.constant.BalanceType;
import cn.com.duiba.tuia.activity.center.api.dto.ActivityWinOrderDto;
import cn.com.duiba.tuia.activity.center.api.dto.consumer.UserBalanceDto;
import cn.com.duiba.tuia.activity.center.api.dto.consumer.req.BalanceRecordAdd;
import cn.com.duiba.tuia.activity.center.api.dto.consumer.req.BalanceWithdrawReq;
import cn.com.duiba.tuia.activity.center.api.exception.ActivityCenterException;
import cn.com.duiba.tuia.activity.center.api.remoteservice.RemoteActivityWinOrderService;
import cn.com.duiba.tuia.activity.center.api.remoteservice.RemoteUserBalanceService;
import com.duiba.tuia.youtui.web.service.SystemConfigService;
import com.duiba.tuia.youtui.web.service.UserBalanceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class UserBalanceServiceImpl implements UserBalanceService {

    protected Logger logger = LoggerFactory.getLogger(getClass());

    @Resource
    private RemoteUserBalanceService remoteUserBalanceService;

    @Autowired
    private SystemConfigService systemConfigService;

    @Autowired
    private RemoteActivityWinOrderService remoteActivityWinOrderService;

    @Override
    public Long getAmount(Long userId, Integer balanceType) {
        return remoteUserBalanceService.getAmount(userId, balanceType == 1 ? BalanceType.CASH : BalanceType.GAME);
    }

    @Override
    public UserBalanceDto getByType(Long userId, BalanceType type) {
        return remoteUserBalanceService.getByType(userId, type);
    }

    @Override
    public String addAmount(BalanceRecordAdd adder) {
        return remoteUserBalanceService.updateAmount4OrderId(adder);
    }

    @Override
    public Integer forceUpdateAmount(Long userId, Long amount, BalanceType balanceType) {
        BalanceRecordAdd add = new BalanceRecordAdd();
        add.setUserId(userId);
        add.setBalanceType(balanceType);
        add.setAmount(amount);
        return remoteUserBalanceService.forceUpdateAmount(add);
    }

    @Override
    public Long createBalance(Long appId, Long userId, BalanceType balanceType, Long initAmount){
        return remoteUserBalanceService.createBalanceWithInit(appId, userId,balanceType, initAmount);
    }

    @Override
    public String getWithdrawConfig() {
        return systemConfigService.getSystemConfig("tuia_guide_page_money_withdraw_list");
    }

    @Override
    public ActivityWinOrderDto cashWithdraw(BalanceWithdrawReq req) throws ActivityCenterException {
        return remoteActivityWinOrderService.cashWithdraw(req);
    }

}
