/**
 * Project Name:tuia-youtui-web<br>
 * File Name:ActivityEngineServiceImpl.java<br>
 * Package Name:com.duiba.tuia.youtui.web.service.impl<br>
 * Date:2017年4月14日上午11:56:39<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */

package com.duiba.tuia.youtui.web.service.impl;

import cn.com.duiba.dayu.api.client.DayuClient;
import cn.com.duiba.dayu.api.enums.ArgumentType;
import cn.com.duiba.dayu.api.result.DayuResult;
import cn.com.duiba.tuia.activity.center.api.dto.ActivitySkinDataDto;
import cn.com.duibaboot.ext.autoconfigure.accesslog.AccessLogFilter;
import com.duiba.tuia.youtui.web.exception.ActivityException;
import com.duiba.tuia.youtui.web.service.BaseService;
import com.duiba.tuia.youtui.web.service.DaYuService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.EnumMap;
import java.util.Map;

/**
 * ClassName: ActivityEngineServiceImpl <br/>
 * date: 2017年4月14日 上午11:56:39 <br/>
 * .
 *
 * @author youhaijun
 * @since JDK 1.7
 */
@Service
public class DaYuServiceImpl extends BaseService implements DaYuService {

    @Resource
    private DayuClient dayuClient;

    @Value("${taw.skin.abtest.scene}")
    private String dollMacScene;
    @Value("${taw.skin.abtest.rollDice.scene}")
    private String rollDiceScene;



    @Override
    public String activitySkinABTest(ActivitySkinDataDto activitySkinDataDto, Long consumerId) throws ActivityException {
        String skinType = activitySkinDataDto.getSkinType();
        if ("dollMac_2".equals(skinType)) {
            return getSkinType(dollMacScene, consumerId);
        } else if ("rollDice_2".equals(skinType)) {
            return getSkinType(rollDiceScene, consumerId);
        }
        return null;
    }

    private String getSkinType(String scene, Long consumerId) {
        try {
            EnumMap<ArgumentType, Object> argumentTypeObjectEnumMap = new EnumMap<>(ArgumentType.class);
            argumentTypeObjectEnumMap.put(ArgumentType.CONSUMER_ID, consumerId);
            DayuResult handleResult = dayuClient.handleRequest("scene:" + scene, argumentTypeObjectEnumMap);
            if (null != handleResult) {
                Map<String, String> arguments = handleResult.getArguments();
                String skinType = arguments.get("skinType");
                if (StringUtils.isNotBlank(skinType)) {
                    AccessLogFilter.putExPair("skinType", skinType);
                    return skinType;
                }
            }
        } catch (Exception e) {
            logger.warn("大禹接口异常", e);
        }
        return null;
    }
}
