package com.duiba.tuia.youtui.web.service;

import cn.com.duiba.tuia.activity.center.api.constant.BalanceType;
import cn.com.duiba.tuia.activity.center.api.dto.ActivityWinOrderDto;
import cn.com.duiba.tuia.activity.center.api.dto.consumer.UserBalanceDto;
import cn.com.duiba.tuia.activity.center.api.dto.consumer.req.BalanceRecordAdd;
import cn.com.duiba.tuia.activity.center.api.dto.consumer.req.BalanceWithdrawReq;
import cn.com.duiba.tuia.activity.center.api.exception.ActivityCenterException;

public interface UserBalanceService {

    Long getAmount(Long userId, Integer balanceType);

    /**
     * 根据用户id获取金额账户列表
     *
     * @param userId 用户id
     * @return 用户金额列表
     */
    UserBalanceDto getByType(Long userId, BalanceType type);

    /**
     * 添加账户变动记录
     *
     * @return 订单id
     */
    String addAmount(BalanceRecordAdd adder);


    /**
     * 第三方媒体提供金币来源时，用户访问时强制同步金币余额
     * @param userId
     * @param amount
     * @return
     */
    Integer forceUpdateAmount(Long userId, Long amount, BalanceType balanceType);

    Long createBalance(Long appId, Long userId, BalanceType balanceType, Long initAmount);

    /**
     * 获取现金钱包用户提现配置
     *
     * @return
     */
    String getWithdrawConfig();

    /**
     *
     *
     * @param req
     * @return
     * @throws ActivityCenterException
     */
    ActivityWinOrderDto cashWithdraw(BalanceWithdrawReq req) throws ActivityCenterException;
}
