package com.duiba.tuia.youtui.web.service;

public interface StockService {
    /**
     * 查询库存
     * 异常返回null
     * @param stockId 库存id
     * @return 库存值
     */
    Long find(Long stockId);

    /**
     * 扣一个库存
     * @param orderId 订单id
     * @param stockId 库存id
     * @return 是否成功
     */
    boolean consumeStock(String orderId, Long stockId);

    /**
     * 扣多个库存
     * @param orderId 订单id
     * @param stockId 库存id
     * @param num 库存数量
     * @return 是否成功
     */
    boolean consumeStock(String orderId, Long stockId, int num);
}
