package com.duiba.tuia.youtui.web.service;

import com.duiba.tuia.youtui.web.exception.ActivityException;

/**
 * ClassName: SmsService <br/>
 * Function: 短信Service. <br/>
 * date: 2017年03月28日  10:29:00 <br/>
 *
 * @author zdx
 * @version 1.0
 * @since JDK 1.7
 */
public interface SmsService {

    /**
     * 发送验证码
     * @param phone 手机号
     * @param channel 渠道
     * @return
     * @throws ActivityException
     */
    Boolean send(String phone,String channel) throws ActivityException;
    
    /**
     * 校验短信验证码
     * @param phone 手机号
     * @param code 验证码
     * @param channel 渠道
     * @return
     * @throws ActivityException
     */
    Boolean verify(String phone, String code, String channel);
    
}
