
/**
 * Project Name:tuia-youtui-web<br>
 * File Name:LuckBagService.java<br>
 * Package Name:com.duiba.tuia.youtui.web.service<br>
 * Date:2017年1月23日下午4:08:16<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 *
 */

package com.duiba.tuia.youtui.web.service;

import cn.com.tuia.advert.model.ObtainAdvertRsp;
import cn.com.tuia.advert.model.QueryAdvertRsp;

import com.duiba.tuia.youtui.web.model.req.DoJoinActivityReq;


/**
 * ClassName: LuckBagService <br/>
 * Function: 福袋接口. <br/>
 * date: 2017年1月23日 下午4:08:16 <br/>
 *
 * @author leiliang
 * @version 
 * @since JDK 1.6
 */
public interface LuckBagService {
    
    /**
     * Luck bag request server.
     *
     * @param doJoinActivityReq the do join activity req
     * @param activityTag the activity tag
     * @param orderId the order id
     * @param advertId the advert id
     * @return the long
     */
    ObtainAdvertRsp obtainAdvert(DoJoinActivityReq doJoinActivityReq, String activityTag, String orderId, Long advertId);
    
    /**
     * 广告查询接口
     * queryAdvert:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param consumerId the consumer id
     * @param orderId the order id
     * @param showType the show type
     * @param slotId the slot id
     * @return the query advert rsp
     * @author zp
     * @since JDK 1.6
     */
    QueryAdvertRsp queryAdvert(Long consumerId, String orderId,Integer showType,Long slotId);

}

