package com.duiba.tuia.youtui.web.service;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.tuia.activity.center.api.dto.LandDto;
import cn.com.duiba.tuia.activity.center.api.remoteservice.RemoteLandService;
import cn.com.duiba.wolf.utils.BeanUtils;

import com.duiba.tuia.youtui.web.exception.ActivityRuntimeException;
import com.duiba.tuia.youtui.web.model.rsp.LandRsp;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;

@Service
public class LocalCacheService {

	private Cache<Long, LandRsp> localCache = CacheBuilder.newBuilder().expireAfterWrite(1, TimeUnit.MINUTES).build();
    @Autowired
	private RemoteLandService remoteLandService;
    
    public LandRsp getValueIn5Min(final Long key) throws ExecutionException{
        return localCache.get(key, new Callable<LandRsp>() {
			public LandRsp call() throws Exception {
				LandDto land = remoteLandService.selectLandById(key).getResult();
				if(land == null){
					throw new ActivityRuntimeException("内容不存在");
				}
				LandRsp landRsp = BeanUtils.copy(land, LandRsp.class);
				landRsp.setAutoDownloadTime(land.getAutoDownloadDoubleTime());
				return landRsp;
			}
		});
    }
}
