package com.duiba.tuia.youtui.web.service;

import cn.com.duiba.tuia.activity.center.api.dto.LandUserInfoDto;
import cn.com.duiba.tuia.activity.center.api.dto.rsp.AlipayCmapRsp;

import com.duiba.tuia.youtui.web.biz.land.param.LandExtendParam;
import com.duiba.tuia.youtui.web.biz.land.param.LandParamI;
import com.duiba.tuia.youtui.web.exception.ActivityException;
import com.duiba.tuia.youtui.web.model.req.LandUserFormInfo;
import com.duiba.tuia.youtui.web.model.req.LandUserInfo;
import com.duiba.tuia.youtui.web.model.rsp.InsuranceResultRsp;

import javax.servlet.http.HttpServletResponse;

/**
 * ClassName: LandService <br/>
 * Function: 落地页. <br/>
 * date: 2017年3月24日  11:08:16 <br/>
 *
 * @author zdx
 * @version 1.0
 * @since JDK 1.7
 */
public interface LandService {

	/**
	 * 执行落地业务
	 * @param info  
	 * @param extendParam
	 */
	void LandingPage(LandUserInfo info, LandExtendParam extendParam, HttpServletResponse response) throws ActivityException;
	
	/**
	 * 手机是否已存在该落地页
	 * @param phone 手机号
	 * @param landId 落地页id
	 */
	Boolean isExist(String phone, Long landId);
	
	LandParamI getParam(LandUserInfo info);
	
	/**
	 * insurancePage:(保险落地页业务). <br/>
	 * @return
	 */
	InsuranceResultRsp insurancePage(LandUserInfo info, LandExtendParam extendParam);
	
	Boolean updateUserInfo(LandUserInfo info,String interfaceCode);

	AlipayCmapRsp drawcmapTrigger(LandUserInfoDto landUserInfoDto, String type);

	/**
	 * 
	 * submitForm:(模板落地页提交表单). <br/>
	 *
	 * @author chencheng
	 * @param landUserInfo
	 * @param extendParam
	 * @return
	 * @throws ActivityException
	 * @since JDK 1.8
	 */
    void submitForm(LandUserFormInfo landUserInfo, LandExtendParam extendParam) throws ActivityException;
	
}
