
/**
 * Project Name:tuia-youtui-web<br>
 * File Name:ConsumerBo.java<br>
 * Package Name:com.duiba.tuia.youtui.web.bo<br>
 * Date:2017年1月22日上午9:55:06<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 *
 */

package com.duiba.tuia.youtui.web.service;

import cn.com.duiba.tuia.ssp.center.api.dto.MediaAppDataDto;
import cn.com.duiba.tuia.ssp.center.api.dto.MediaAppDto;

import java.util.Optional;
import java.util.concurrent.ExecutionException;


/**
 * ClassName: ConsumerBo <br/>
 * Function: APP. <br/>
 * date: 2017年1月22日 上午9:55:06 <br/>
 *
 * @author leiliang  update chengdeman 2017-07-14  去除依赖 developer-center 使用ssp－center的接口
 * @version 
 * @since JDK 1.6
 */
public interface AppService {

    /**
     * Find app by app key.
     *
     * @param appKey the app key
     * @return the app simple dto
     * @throws ExecutionException the activity exception
     */
    MediaAppDataDto findAppByAppKey(String appKey) throws ExecutionException;

    /**
     * 根据appId查询app信息
     *
     * @param appId
     * @return
     */
    Optional<MediaAppDto> getMediaApp(Long appId);

    /**
     * 刷新缓存的方法
     * @param appId 媒体id
     * @param appKey 媒体key
     */
    void refreshCache(Long appId,String appKey);
}

