package com.duiba.tuia.youtui.web.model.toutiao;

import com.duiba.tuia.youtui.web.model.toutiao.Adslot;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by xuefeng on 2017/10/27.
 */
public class TouTiaoBidRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    @JsonProperty("request_id")
    private String requestId;
    @JsonProperty("api_version")
    private String apiVersion;
    private String uid;
    @JsonProperty("source_type")
    private String sourceType;
    private String ua;
    private String ip;

    private User user;
    private App app;
    private Wap wap;
    private Device device;
    private List<Adslot> adslots;

    public String getRequestId() {
        return requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getApiVersion() {
        return apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getUa() {
        return ua;
    }

    public void setUa(String ua) {
        this.ua = ua;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public User getUser() {
        return user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public App getApp() {
        return app;
    }

    public void setApp(App app) {
        this.app = app;
    }

    public Wap getWap() {
        return wap;
    }

    public void setWap(Wap wap) {
        this.wap = wap;
    }

    public Device getDevice() {
        return device;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public List<Adslot> getAdslots() {
        return adslots;
    }

    public void setAdslots(List<Adslot> adslots) {
        this.adslots = adslots;
    }

    public TouTiaoBidRequest() {
        user = new User();
        app = new App();
        wap = new Wap();
        device = new Device();
        adslots = new ArrayList<>();
    }

    public class User implements Serializable {
        private static final long serialVersionUID = -402427749490699497L;
        private Integer gender;
        private Integer age;
        private String keywords;
        @JsonProperty("app_list")
        private List<String> appList;
        private String data;

        public Integer getGender() {
            return gender;
        }

        public void setGender(Integer gender) {
            this.gender = gender;
        }

        public Integer getAge() {
            return age;
        }

        public void setAge(Integer age) {
            this.age = age;
        }

        public String getKeywords() {
            return keywords;
        }

        public void setKeywords(String keywords) {
            this.keywords = keywords;
        }

        public List<String> getAppList() {
            return appList;
        }

        public void setAppList(List<String> appList) {
            this.appList = appList;
        }

        public String getData() {
            return data;
        }

        public void setData(String data) {
            this.data = data;
        }
    }

    public class App implements Serializable {
        private static final long serialVersionUID = -1725446073700037158L;
        private String appid;
        private String name;
        @JsonProperty("package_name")
        private String packageName;
        @JsonProperty("app_category")
        private Integer appCategory;
        private String version;
        @JsonProperty("is_paid_app")
        private Boolean isPaidApp;
        private Geo geo;

        public String getAppid() {
            return appid;
        }

        public void setAppid(String appid) {
            this.appid = appid;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPackageName() {
            return packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public Integer getAppCategory() {
            return appCategory;
        }

        public void setAppCategory(Integer appCategory) {
            this.appCategory = appCategory;
        }

        public String getVersion() {
            return version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public Boolean getPaidApp() {
            return isPaidApp;
        }

        public void setPaidApp(Boolean paidApp) {
            isPaidApp = paidApp;
        }

        public Geo getGeo() {
            return geo;
        }

        public void setGeo(Geo geo) {
            this.geo = geo;
        }

        class Geo implements Serializable {
            private static final long serialVersionUID = -3078522848503398643L;
            //纬度
            private float latitude;
            //经度
            private float longitude;
            private String city;
            private String province;
            private String distinct;

            public float getLatitude() {
                return latitude;
            }

            public void setLatitude(float latitude) {
                this.latitude = latitude;
            }

            public float getLongitude() {
                return longitude;
            }

            public void setLongitude(float longitude) {
                this.longitude = longitude;
            }

            public String getCity() {
                return city;
            }

            public void setCity(String city) {
                this.city = city;
            }

            public String getProvince() {
                return province;
            }

            public void setProvince(String province) {
                this.province = province;
            }

            public String getDistinct() {
                return distinct;
            }

            public void setDistinct(String distinct) {
                this.distinct = distinct;
            }
        }
    }

    public class Wap implements Serializable {
        private static final long serialVersionUID = 5030508824056937393L;
        @JsonProperty("site_id")
        private String siteId;
        private String title;
        @JsonProperty("site_category")
        private Integer siteCategory;
        private String url;
        private String referral;
        private String info;

        public String getSiteId() {
            return siteId;
        }

        public void setSiteId(String siteId) {
            this.siteId = siteId;
        }

        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public Integer getSiteCategory() {
            return siteCategory;
        }

        public void setSiteCategory(Integer siteCategory) {
            this.siteCategory = siteCategory;
        }

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getReferral() {
            return referral;
        }

        public void setReferral(String referral) {
            this.referral = referral;
        }

        public String getInfo() {
            return info;
        }

        public void setInfo(String info) {
            this.info = info;
        }
    }

    public class Device implements Serializable {
        private static final long serialVersionUID = -2834309890447333825L;
        private String did;
        private String imei;
        @JsonProperty("android_id")
        private String androidId;
        private String uuid;
        private String openudid;
        private String ssid;
        @JsonProperty("wifi_mac")
        private String wifiMac;
        @JsonProperty("phone_namel")
        private String phoneNamel;
        private String dsid;
        @JsonProperty("power_on_time")
        private String powerOnTime;
        private String imsi;
        @JsonProperty("rom_version")
        private String romVersion;
        @JsonProperty("sys_comiling_time")
        private String sysComilingTime;
        private String type;
        private String os;
        @JsonProperty("os_version")
        private String osVersion;
        private String vendor;
        private String model;
        private String language;
        @JsonProperty("con_type")
        private String connType;
        private String mac;
        @JsonProperty("screen_width")
        private String screenWidth;
        @JsonProperty("screen_height")
        private String screenHeight;

        public String getDid() {
            return did;
        }

        public void setDid(String did) {
            this.did = did;
        }

        public String getImei() {
            return imei;
        }

        public void setImei(String imei) {
            this.imei = imei;
        }

        public String getAndroidId() {
            return androidId;
        }

        public void setAndroidId(String androidId) {
            this.androidId = androidId;
        }

        public String getUuid() {
            return uuid;
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public String getOpenudid() {
            return openudid;
        }

        public void setOpenudid(String openudid) {
            this.openudid = openudid;
        }

        public String getSsid() {
            return ssid;
        }

        public void setSsid(String ssid) {
            this.ssid = ssid;
        }

        public String getWifiMac() {
            return wifiMac;
        }

        public void setWifiMac(String wifiMac) {
            this.wifiMac = wifiMac;
        }

        public String getPhoneNamel() {
            return phoneNamel;
        }

        public void setPhoneNamel(String phoneNamel) {
            this.phoneNamel = phoneNamel;
        }

        public String getDsid() {
            return dsid;
        }

        public void setDsid(String dsid) {
            this.dsid = dsid;
        }

        public String getPowerOnTime() {
            return powerOnTime;
        }

        public void setPowerOnTime(String powerOnTime) {
            this.powerOnTime = powerOnTime;
        }

        public String getImsi() {
            return imsi;
        }

        public void setImsi(String imsi) {
            this.imsi = imsi;
        }

        public String getRomVersion() {
            return romVersion;
        }

        public void setRomVersion(String romVersion) {
            this.romVersion = romVersion;
        }

        public String getSysComilingTime() {
            return sysComilingTime;
        }

        public void setSysComilingTime(String sysComilingTime) {
            this.sysComilingTime = sysComilingTime;
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getOs() {
            return os;
        }

        public void setOs(String os) {
            this.os = os;
        }

        public String getOsVersion() {
            return osVersion;
        }

        public void setOsVersion(String osVersion) {
            this.osVersion = osVersion;
        }

        public String getVendor() {
            return vendor;
        }

        public void setVendor(String vendor) {
            this.vendor = vendor;
        }

        public String getModel() {
            return model;
        }

        public void setModel(String model) {
            this.model = model;
        }

        public String getLanguage() {
            return language;
        }

        public void setLanguage(String language) {
            this.language = language;
        }

        public String getConnType() {
            return connType;
        }

        public void setConnType(String connType) {
            this.connType = connType;
        }

        public String getMac() {
            return mac;
        }

        public void setMac(String mac) {
            this.mac = mac;
        }

        public String getScreenWidth() {
            return screenWidth;
        }

        public void setScreenWidth(String screenWidth) {
            this.screenWidth = screenWidth;
        }

        public String getScreenHeight() {
            return screenHeight;
        }

        public void setScreenHeight(String screenHeight) {
            this.screenHeight = screenHeight;
        }
    }
}
