/**
 * Project Name:tuia-youtui-web<br>
 * File Name:RecommendRsp.java<br>
 * Package Name:com.duiba.tuia.youtui.web.model.rsp<br>
 * Date:2017年4月13日下午4:59:48<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */

package com.duiba.tuia.youtui.web.model.rsp;

import java.io.Serializable;

import com.duiba.tuia.youtui.web.model.BtnClose;
import org.apache.commons.lang.builder.ToStringBuilder;

import com.duiba.tuia.youtui.web.biz.interfaces.ImageBusiness;
import com.duiba.tuia.youtui.web.model.BlockDto;
import com.duiba.tuia.youtui.web.tool.DomainUtil;

/**
 * ClassName: RecommendRsp <br/>
 * date: 2017年4月13日 下午4:59:48 <br/>
 *
 * @author youhaijun
 * @since JDK 1.7
 */
public class RecommendRsp implements Serializable, ImageBusiness {

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = -9083183718100260137L;

    private BlockDto block1;

    private BlockDto block2;

    private String stRecommendInfo;

    private BlockDto block3;

    private BlockDto block4;

    private BtnClose btnClose;

    private BtnClose btnClose2;

    public String getStRecommendInfo() {
        return stRecommendInfo;
    }

    public void setStRecommendInfo(String stRecommendInfo) {
        this.stRecommendInfo = stRecommendInfo;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public BlockDto getBlock1() {
        return block1;
    }

    public void setBlock1(BlockDto block1) {
        this.block1 = block1;
    }

    public BlockDto getBlock2() {
        return block2;
    }

    public void setBlock2(BlockDto block2) {
        this.block2 = block2;
    }

    public BlockDto getBlock3() {
        return block3;
    }

    public void setBlock3(BlockDto block3) {
        this.block3 = block3;
    }

    public BlockDto getBlock4() {
        return block4;
    }

    public void setBlock4(BlockDto block4) {
        this.block4 = block4;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public BtnClose getBtnClose() {
        return btnClose;
    }

    public void setBtnClose(BtnClose btnClose) {
        this.btnClose = btnClose;
    }

    public BtnClose getBtnClose2() {
        return btnClose2;
    }

    public void setBtnClose2(BtnClose btnClose2) {
        this.btnClose2 = btnClose2;
    }

    @Override
    public void replaceDomain(String domain) {
        if (block1 != null) {
            block1.setBannerUrl(DomainUtil.replaceDomain(block1.getBannerUrl(), domain));
        }
        if (block2 != null) {
            block2.setBannerUrl(DomainUtil.replaceDomain(block2.getBannerUrl(), domain));
        }

    }
}
