/**
 * Project Name:manager-domain<br>
 * File Name:LandRsp.java<br>
 * Package Name:cn.com.duiba.tuia.manager.rsp<br>
 * Date:2017年3月24日下午5:28:22<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */
package com.duiba.tuia.youtui.web.model.rsp;

import org.apache.commons.lang.builder.ToStringBuilder;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * ClassName: LandRsp <br/>
 * Function: 落地页接口返回类. <br/>
 * Reason: . <br/>
 * date: 2017年3月24日 下午5:28:22 <br/>
 *
 * @author wubo
 * @version
 * @since JDK 1.7
 */
@ApiModel("落地页信息")
public class LandRsp implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long              id;

    /** title:落地页标题. */
    @ApiModelProperty("落地页标题")
    private String            title;

    /** html:落地页皮肤. */
    @ApiModelProperty("html:落地页代码")
    private String            html;

    /** link:预览链接. */
    @ApiModelProperty("预览链接")
    private String            link;

    /** 网页名称. */
    @ApiModelProperty("网页名称")
    private String            webPageName;

    /** 0：代码添加，1：模板添加. */
    @ApiModelProperty("0：代码添加，1：模板添加")
    private Integer           landType;

    /** 自动下载：0-非，1-是. */
    @ApiModelProperty("自动下载：0-非，1-是.")
    private Integer           autoDownload;

    /** 自动下载时间. */
    @ApiModelProperty("自动下载时间")
    private Double            autoDownloadTime;

    /** 安卓下载地址. */
    @ApiModelProperty("安卓下载地址")
    private String            downloadAndriod;

    /** ios下载地址. */
    @ApiModelProperty("ios下载地址")
    private String            downloadIos;

    /** 自动跳转类型：0:链接,1:弹层 */
    @ApiModelProperty("自动跳转类型：0:链接,1:弹层")
    private Integer           autoDownloadType;

    public LandRsp() {
        super();
    }

    /**
     * webPageName.
     *
     * @return the webPageName
     * @since JDK 1.8
     */
    public String getWebPageName() {
        return webPageName;
    }

    /**
     * webPageName.
     *
     * @param webPageName the webPageName to set
     * @since JDK 1.8
     */
    public void setWebPageName(String webPageName) {
        this.webPageName = webPageName;
    }

    /**
     * landType.
     *
     * @return the landType
     * @since JDK 1.8
     */
    public Integer getLandType() {
        return landType;
    }

    /**
     * landType.
     *
     * @param landType the landType to set
     * @since JDK 1.8
     */
    public void setLandType(Integer landType) {
        this.landType = landType;
    }

    /**
     * autoDownload.
     *
     * @return the autoDownload
     * @since JDK 1.8
     */
    public Integer getAutoDownload() {
        return autoDownload;
    }

    /**
     * autoDownload.
     *
     * @param autoDownload the autoDownload to set
     * @since JDK 1.8
     */
    public void setAutoDownload(Integer autoDownload) {
        this.autoDownload = autoDownload;
    }

    /**
     * autoDownloadTime.
     *
     * @return the autoDownloadTime
     * @since JDK 1.8
     */
    public Double getAutoDownloadTime() {
        return autoDownloadTime;
    }

    /**
     * autoDownloadTime.
     *
     * @param autoDownloadTime the autoDownloadTime to set
     * @since JDK 1.8
     */
    public void setAutoDownloadTime(Double autoDownloadTime) {
        this.autoDownloadTime = autoDownloadTime;
    }

    /**
     * autoDownloadType.
     *
     * @return the autoDownloadType
     * @since JDK 1.8
     */
    public Integer getAutoDownloadType() {
        return autoDownloadType;
    }

    /**
     * autoDownloadType.
     *
     * @param autoDownloadType the autoDownloadType to set
     * @since JDK 1.8
     */
    public void setAutoDownloadType(Integer autoDownloadType) {
        this.autoDownloadType = autoDownloadType;
    }

    /**
     * downloadAndriod.
     *
     * @return the downloadAndriod
     * @since JDK 1.8
     */
    public String getDownloadAndriod() {
        return downloadAndriod;
    }

    /**
     * downloadAndriod.
     *
     * @param downloadAndriod the downloadAndriod to set
     * @since JDK 1.8
     */
    public void setDownloadAndriod(String downloadAndriod) {
        this.downloadAndriod = downloadAndriod;
    }

    /**
     * downloadIos.
     *
     * @return the downloadIos
     * @since JDK 1.8
     */
    public String getDownloadIos() {
        return downloadIos;
    }

    /**
     * downloadIos.
     *
     * @param downloadIos the downloadIos to set
     * @since JDK 1.8
     */
    public void setDownloadIos(String downloadIos) {
        this.downloadIos = downloadIos;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getHtml() {
        return html;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public String getLink() {
        return link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
