package com.duiba.tuia.youtui.web.model.rsp;

import cn.com.duiba.tuia.activity.center.api.dto.ActivityOptionDto;
import com.duiba.tuia.youtui.web.biz.interfaces.ImageBusiness;
import com.duiba.tuia.youtui.web.tool.DomainUtil;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;

/**
 * The Class ActivityOptionRsp.
 */
public class ActivityOptionRsp implements ImageBusiness{

    /** 限制类型. */
    private Integer                 limitType;
    
    /** 剩余参与次数. */
    private Integer                 limitTimes;
    
    /** 奖项信息. */
    private List<ActivityOptionDto> options;

    /** 埋点数据. */
    private Map<String, String>     embedData;

    private Boolean                 isOpenPrizeInfo;                          // 展示奖品信息 0:关闭 1:打开

    @Override
    public void replaceDomain(String domain) {
        if (!CollectionUtils.isEmpty(options)) {
            for (ActivityOptionDto dto : options) {
                dto.setImage(DomainUtil.replaceDomain(dto.getImage(), domain));
                dto.setDetailImg(DomainUtil.replaceDomain(dto.getDetailImg(), domain));
            }
        }
    }

    public Boolean getIsOpenPrizeInfo() {
        return isOpenPrizeInfo;
    }

    public void setIsOpenPrizeInfo(Boolean isOpenPrizeInfo) {
        this.isOpenPrizeInfo = isOpenPrizeInfo;
    }

    /**
     * Gets the limit type.
     *
     * @return the limit type
     */
    public Integer getLimitType() {
        return limitType;
    }

    /**
     * Sets the limit type.
     *
     * @param limitType the limit type
     */
    public void setLimitType(Integer limitType) {
        this.limitType = limitType;
    }

    /**
     * Gets the limit times.
     *
     * @return the limit times
     */
    public Integer getLimitTimes() {
        return limitTimes;
    }

    /**
     * Sets the limit times.
     *
     * @param limitTimes the limit times
     */
    public void setLimitTimes(Integer limitTimes) {
        this.limitTimes = limitTimes;
    }

    /**
     * Gets the options.
     *
     * @return the options
     */
    public List<ActivityOptionDto> getOptions() {
        return options;
    }

    /**
     * Sets the options.
     *
     * @param options the options
     */
    public void setOptions(List<ActivityOptionDto> options) {
        this.options = options;
    }

    public Map<String, String> getEmbedData() {
        return embedData;
    }

    public void setEmbedData(Map<String, String> embedData) {
        this.embedData = embedData;
    }
}
