package com.duiba.tuia.youtui.web.model.req;

import io.swagger.annotations.ApiModel;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;

/**
 * 虚拟奖品-用户信息填写请求
 *
 * Created by xuefeng on 2017/11/16.
 */
@ApiModel
public class VirtualWinnerReq{

    @NotNull(message = "订单号不可为空")
    @Length(min=13, max=64)
    private String orderId;

    private Integer subType;

    private String prizeIdent;

    private String infoReqs;

    private String appKey;

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public String getPrizeIdent() {
        return prizeIdent;
    }

    public void setPrizeIdent(String prizeIdent) {
        this.prizeIdent = prizeIdent;
    }

    public String getInfoReqs() {
        return infoReqs;
    }

    public void setInfoReqs(String infoReqs) {
        this.infoReqs = infoReqs;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }
}
