package com.duiba.tuia.youtui.web.model.direct;

import cn.com.duiba.tuia.activity.center.api.constant.PageType;
import cn.com.duiba.tuia.activity.center.api.dto.GuidePageBlockDto;
import com.duiba.tuia.youtui.web.embed.DcmBuilder;
import com.duiba.tuia.youtui.web.embed.DirectEmbed;
import com.duiba.tuia.youtui.web.embed.DpmBuilder;
import com.duiba.tuia.youtui.web.model.req.DirectPageReq;
import com.duiba.tuia.youtui.web.model.req.IndexReq;
import com.duiba.tuia.youtui.web.tool.PathUtil;

/**
 * 主会场区块 Created by wubo on 2017/9/27.
 */
public class DirectBlock extends Block {

    private Long directId;

    public Long getDirectId() {
        return directId;
    }

    public void setDirectId(Long directId) {
        this.directId = directId;
    }

    public DirectBlock(GuidePageBlockDto dto, Long directId) {
        super(dto);
        this.directId = directId;
    }

    @Override
    public void buildEmbed(String dsm, int regionNum, int blockNum, Long consumerId, Long appId, String host,Long directPage) {
        super.setDpm(DpmBuilder.directBlockBuild(appId, regionNum, blockNum));
        super.setDcm(DcmBuilder.directDirectBlockBuild(directId, super.getPageId()));
        super.setDsm(dsm);
        DirectEmbed directEmbed = new DirectEmbed(super.getDcm(), dsm, super.getDpm(), consumerId, appId, host,directPage);
        super.setEmbedInfo(directEmbed.buildAdvertEmbed());
    }

    @Override
    public void buildUrl(DirectPageReq req) {
        IndexReq indexReq = new IndexReq();
        indexReq.setId(super.getPageId());
        indexReq.setAppKey(req.getAppKey());
        indexReq.setLogin(req.getLogin());
        indexReq.setSlotId(req.getSlotId());
        indexReq.setDeviceId(req.getDeviceId());
        indexReq.setDcm(super.getDcm());
        indexReq.setDsm(super.getDsm());
        indexReq.setDpm(super.getDpm());
        indexReq.setHost(req.getHost());
        super.setUrl(PathUtil.getGuidePageUrl(directId, indexReq, PageType.DIRECT.getCode()));

    }
}
