package com.duiba.tuia.youtui.web.model;

import java.util.HashMap;
import java.util.Map;

import cn.com.duiba.tuia.activity.center.api.constant.ParseType;

/**
 * ClassName: HttpRequest <br/>
 * Function: http 请求内容封装. <br/>
 * Reason: . <br/>
 * date: 2017年4月17日 下午8:18:35 <br/>
 *
 * @author wubo
 * @version
 * @since JDK 1.7
 */
public class HttpRequest {

    private String              url;
    private String              method;
    private ParseType           requestType;
    private Map<String, String> urlParams;
    private Map<String, String> headParams;
    private Map<String, Object> bodyParams;
    private String              request;
    private String              response;

    /**
     * Creates a new instance of HttpRequest.
     */
    public HttpRequest() {
        urlParams = new HashMap<>();
        headParams = new HashMap<>();
        bodyParams = new HashMap<>();
    }

    /**
     * Creates a new instance of HttpRequest.
     *
     * @param url http链接
     * @param method http方法
     * @param urlParams url参数
     * @param bodyParams body参数
     */
    public HttpRequest(String url, String method, Map<String, String> urlParams, Map<String, String> headParams,
                       Map<String, Object> bodyParams) {
        this.url = url;
        this.method = method;
        this.urlParams = urlParams;
        this.headParams = headParams;
        this.bodyParams = bodyParams;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public ParseType getRequestType() {
        return requestType;
    }

    public void setRequestType(ParseType requestType) {
        this.requestType = requestType;
    }

    public String getRequest() {
        if (request == null && bodyParams != null) {
            request = bodyParams.toString();
        }
        return request;
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public String getResponse() {
        return response;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public Map<String, String> getUrlParams() {
        return urlParams;
    }
    
    public Map<String, String> getHeadParams() {
        return headParams;
    }

    public Map<String, Object> getBodyParams() {
        return bodyParams;
    }

    public void putUrlParameter(String key, Object value) {
        if (urlParams == null) {
            urlParams = new HashMap<>();
        }
        if (value != null) {
            urlParams.put(key, value.toString());
        }

    }

    public void putAllUrlParameter(Map<String, String> urlParameters) {
        this.urlParams.putAll(urlParameters);
    }

    public void putHeadParameter(String key, Object value) {
        if (headParams == null) {
            headParams = new HashMap<>();
        }
        if (value != null) {
            headParams.put(key, value.toString());
        }
    }

    public void putAllHeadParameter(Map<String, String> headParameters) {
        if (headParams == null) {
            headParams = new HashMap<>();
        }
        this.headParams.putAll(headParameters);
    }

    public void putBodyParameter(String key, Object value) {
        if (bodyParams == null) {
            bodyParams = new HashMap<>();
        }
        if (value != null) {
            bodyParams.put(key, value);
        }
    }

    public void putAllBodyParameter(Map<String, Object> bodyParameters) {
        this.bodyParams.putAll(bodyParameters);
    }

}
