package com.duiba.tuia.youtui.web.model;

import com.google.common.base.Preconditions;

import java.io.Serializable;

/**
 * 活动web支持的自动登录参数
 */
public class AutoLoginReq implements Serializable {

    private String muId;

    private Long credits;

    private String appKey;

    private String timestamp;

    private String sign;

    private String redirectUrl;

    private Long slotId;

    private String deviceId;

    public boolean checkParam(){
        Preconditions.checkNotNull(this.muId, "参数{}错误", "用户ID");
        Preconditions.checkNotNull(this.appKey, "参数{}错误", "appKey");
        Preconditions.checkNotNull(this.slotId, "参数{}错误", "slotId");
        Preconditions.checkNotNull(this.timestamp, "参数{}错误", "timestamp");
        Preconditions.checkNotNull(this.sign, "参数{}错误", "sign");
        return true;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getMuId() {
        return muId;
    }

    public void setMuId(String muId) {
        this.muId = muId;
    }

    public Long getCredits() {
        return credits;
    }

    public void setCredits(Long credits) {
        this.credits = credits;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getSign() {
        return sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getRedirectUrl() {
        return redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }
}
