package com.duiba.tuia.youtui.web.filter;

import org.apache.catalina.connector.ClientAbortException;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 异常处理
 * Created by wenqi.huang on 16/9/26.
 */
@Component
public class SpringMvcHandlerExceptionResolver extends AbstractHandlerExceptionResolver {
    @Override
    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception e) {
        if (e instanceof IOException && e.getMessage().equals("断开的管道")) {
            logger.info("发生内部错误, because of=[{}]"+e.getMessage());
        }else if(e instanceof ClientAbortException){
            logger.info("发生内部错误, because of=[{}]"+e.getMessage());
        }else{
            logger.error("发生未知错误" ,e);
        }
        return new ModelAndView("error");//error.vm
    }
}
