package com.duiba.tuia.youtui.web.filter;

import javax.annotation.Resource;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

/**
 * Created by wenqi.huang on 16/8/17.
 */
@Configuration
public class SpringMvcConfig extends WebMvcConfigurerAdapter {//WebMvcConfigurationSupport

    @Resource
    private QpsLimitInterceptor qpsLimitInterceptor;
    @Resource
    private SpringMvcHandlerExceptionResolver springMvcHandlerExceptionResolver;
    @Resource
    private LoginInterceptor loginInterceptor;
    @Resource
    private DirectPageSourceInterceptor directPageSourceInterceptor;
    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(loginInterceptor).addPathPatterns("/**");
        registry.addInterceptor(qpsLimitInterceptor).addPathPatterns("/**");
        registry.addInterceptor(directPageSourceInterceptor).addPathPatterns("/**");
    }
    

}
