/**
 * Project Name:tuia-youtui-web<br>
 * File Name:InsuranceException.java<br>
 * Package Name:com.duiba.tuia.youtui.web.exception<br>
 * Date:2017年4月19日下午4:32:25<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */
package com.duiba.tuia.youtui.web.exception;

import com.duiba.tuia.youtui.web.constant.InsuranceMsgEnum;

/**
 * ClassName: InsuranceException <br/>
 * Function: 保险落地页文档异常类. <br/>
 * Reason: . <br/>
 * date: 2017年4月19日 下午4:32:25 <br/>
 *
 * @author wubo
 * @version
 * @since JDK 1.7
 */
public class InsuranceException extends Exception {

    private static final long serialVersionUID = 1L;

    private final String      message;
    private final String      status;
    private final Boolean     success;
    private final String      tip;

    public InsuranceException(InsuranceMsgEnum msg) {
        super(msg.getMessage());
        this.success = false;
        this.status = "1";
        this.message = msg.getMessage();
        this.tip = msg.getTip();
    }

    public InsuranceException(Boolean success, InsuranceMsgEnum msg) {
        super(msg.getMessage());
        this.message = msg.getMessage();
        this.status = "1";
        this.success = success;
        this.tip = msg.getTip();
    }

    public InsuranceException(Boolean success, String status, InsuranceMsgEnum msg) {
        super(msg.getMessage());
        this.message = msg.getMessage();
        this.status = status;
        this.success = success;
        this.tip = msg.getTip();
    }

    public InsuranceException(Boolean success, String status, String message, String tip) {
        super(message);
        this.message = message;
        this.status = status;
        this.success = success;
        this.tip = tip;
    }

    @Override
    public String getMessage() {
        return message;
    }

    public String getTip() {
        return tip;
    }

    public Boolean getSuccess() {
        return success;
    }

    public String getStatus() {
        return status;
    }
}
