package com.duiba.tuia.youtui.web.embed;

import com.alibaba.fastjson.JSONObject;
import com.duiba.tuia.youtui.web.constant.Constants;
import com.duiba.tuia.youtui.web.tool.DomainConstantUtil;

import java.util.HashMap;
import java.util.Map;

import static com.duiba.tuia.youtui.web.constant.Constants.DPM.*;

public class KeFuEmbed {

    private KeFuEmbed() {
    }

    public static  String stServiceClick(Long appId, Long buttonId, Long consumerId, String host){
        String dpm = DpmBuilder.kefuBuild(appId);
        String dcm = DcmBuilder.kefuBuild(buttonId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("domain4Web", "//" + host);
        jsonObject.put("url", Constants.PATH.STATISTICS + Constants.PATH.CLICK);
        jsonObject.put("dpm",dpm);
        jsonObject.put("dcm",dcm);
        jsonObject.put("consumerId",consumerId);
        jsonObject.put("appId",appId);
        return  jsonObject.toJSONString();
    }

    public static  String stServiceInfo(Long appId, Long buttonId, Long consumerId, int dcmD){
        String dpm = DpmBuilder.kefuBuild(appId, dcmD);
        String dcm = DcmBuilder.kefuBuild(buttonId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("domain", DomainConstantUtil.getAppEmbedClickUrl());//埋点服务器Domain
        jsonObject.put("dpm",dpm);
        jsonObject.put("dcm",dcm);
        jsonObject.put("consumerId",consumerId);
        jsonObject.put("appId",appId);
        return  jsonObject.toJSONString();
    }

    public static Map<String, String> buildStEmbed(Long appId, Long buttonId, Long consumerId, String host) {
        Map<String, String> map = new HashMap<>();
        //活动第一页点击埋点
        map.put("stKefuClick", KeFuEmbed.stServiceClick(appId, buttonId, consumerId, host));
        //活动第二页埋点
        map.put("stKefuModalInfo", KeFuEmbed.stServiceInfo(appId, buttonId, consumerId, DPM_D_0));
        map.put("stKefuModalGroundClick", KeFuEmbed.stServiceClick(appId, buttonId, consumerId, host, DPM_D_1));
        map.put("stKefuModalClick", KeFuEmbed.stServiceClick(appId, buttonId, consumerId, host, DPM_D_2));
        map.put("stKefuModalPhoneClick", KeFuEmbed.stServiceClick(appId, buttonId, consumerId, host, DPM_D_3));
        map.put("stKefuModalCancelClick", KeFuEmbed.stServiceClick(appId, buttonId, consumerId, host, DPM_D_4));

        return map;
    }

    public static String stServiceClick(Long appId, Long buttonId, Long consumerId, String host, int dcmD){
        String dpm = DpmBuilder.kefuBuild(appId, dcmD);
        String dcm = DcmBuilder.kefuBuild(buttonId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("domain4Web", "//" + host);
        jsonObject.put("url", Constants.PATH.STATISTICS + Constants.PATH.CLICK);
        jsonObject.put("dpm",dpm);
        jsonObject.put("dcm",dcm);
        jsonObject.put("consumerId",consumerId);
        jsonObject.put("appId",appId);
        return  jsonObject.toJSONString();
    }
}
