package com.duiba.tuia.youtui.web.embed;

import static com.duiba.tuia.youtui.web.constant.Constants.DPM.*;

/**
 * Duiba place Monitor
 * dpm埋点规范:http://cf.dui88.com/pages/viewpage.action?pageId=4493514
 * a:appId
 * b:业务id
 * c:区域id
 * d:区域内序号id
 *
 * 干他妈的dpm
 * Created by wubo on 2017/9/1.
 */
public class DpmBuilder extends DuibaMonitor{

    /**
     * 直投页区块dpm
     * @param appId appId
     * @param regionNum 区域
     * @param blockNum 区块
     * @return string
     */
    public static String directBlockBuild(Long appId, int regionNum, int blockNum) {
        return build(appId, DPM_B_48, regionNum, blockNum);
    }

    /**
     * 返回拦截页面的dpm
     * @param appId appId
     * @return string
     */
    public static String returnPageBuild(Long appId) {
        return build(appId, DPM_B_22, 0, 0);
    }

    /**
     * 客服按钮dpm
     * @param appId appID
     * @return string
     */
    public static String kefuBuild(Long appId){
        return build(appId,DPM_B_3,DPM_C_9,DPM_D_0);
    }

    /**
     * 客服按钮第二页dpm
     * @param appId appID
     * @return string
     */
    public static String kefuBuild(Long appId, int dcmD){
        return build(appId,DPM_B_3,DPM_C_10,dcmD);
    }

    /**
     * 客服按钮dpm
     * @param appId appID
     * @return string
     */
    public static String pluginBuild(Long appId){
        return build(appId,DPM_B_38,DPM_C_1,DPM_D_2);
    }

    /**
     * t推荐弹层dpm
     */
    public static String recommendBuild(Long appId,Long activityId,Integer regionNum){
        return build(appId,DPM_B_36,regionNum,activityId);
    }

    /**
     * 中奖公示按钮dpm
     */
    public static String publicNoticeButtonBuild(Long appId){
        return build(appId,DPM_B_3,DPM_C_11,DPM_D_1);
    }

    /**
     * 中奖公示列表dpm
     */
    public static String publicNoticeListBuild(Long appId){
        return build(appId,DPM_B_62,DPM_C_1,DPM_D_0);
    }

    /**
     * 中奖公示关闭dpm
     */
    public static String publicNoticeCloseBuild(Long appId){
        return build(appId,DPM_B_62,DPM_C_2,DPM_D_1);
    }

    /**
     * 下拉推荐位曝光dpm
     */
    public static String pullDownExposureBuild(Long appId){
        return build(appId,DPM_B_63,DPM_C_1,DPM_D_0);
    }

    /**
     * 下拉推荐位点击dpm
     */
    public static String pullDownClickBuild(Long appId){
        return build(appId,DPM_B_63,DPM_C_1,DPM_D_1);
    }

    /**
     * 游戏厅登录弹层dpm
     */
    public static String gameHallBuild(Long appId, int c, int d){
        return build(appId,DPM_B_64,c,d);
    }

    /**
     * 捕鱼游戏dpm
     */
    public static String gameBuild(Long appId, int c, int d) {
        return build(appId, DPM_B_115, c, d);
    }
    /**
     * 捕鱼排行榜关闭dpm
     */
    public static String colseRankBuild(Long appId) {
        return build(appId, DPM_B_115, DPM_C_3, DPM_D_1);
    }

    /**
     * 捕鱼排行榜券dpm
     */
    public static String advertBuild(Long appId) {
        return build(appId, DPM_B_115, DPM_C_3, DPM_D_2);
    }

    /**
     * 捕鱼排行榜领券dpm
     */
    public static String getAdvertBuild(Long appId) {
        return build(appId, DPM_B_115, DPM_C_3, DPM_D_3);
    }

    /**
     * 捕鱼排行榜换券dpm
     */
    public static String refreshGameBuild(Long appId) {
        return build(appId, DPM_B_115, DPM_C_3, DPM_D_4);
    }

    /**
     * 捕鱼排行榜无券知道按钮dpm
     */
    public static String refreshKnowBuild(Long appId) {
        return build(appId, DPM_B_115, DPM_C_3, DPM_D_5);
    }
}
