package com.duiba.tuia.youtui.web.bo.impl;

import cn.com.duiba.tuia.activity.center.api.constant.ActivityOptionType;
import cn.com.duiba.tuia.activity.center.api.dto.AlipayOrderDto;
import cn.com.duiba.tuia.activity.center.api.dto.req.RechargeReq;
import cn.com.duiba.tuia.activity.center.api.remoteservice.RemoteAlipayService;
import cn.com.duiba.wolf.utils.DateUtils;
import com.duiba.tuia.youtui.web.bo.PrizeBO;
import com.duiba.tuia.youtui.web.constant.CacheKey;
import com.duiba.tuia.youtui.web.model.req.BillReq;
import com.duiba.tuia.youtui.web.model.req.PhysicalReq;
import com.duiba.tuia.youtui.web.service.ActivityOrderService;
import com.duiba.tuia.youtui.web.service.BaseCacheService;
import com.duiba.tuia.youtui.web.tool.CachedKeyUtils;
import com.duiba.tuia.youtui.web.tool.RequestLocal;
import com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

@Service
public class PrizeBOImpl extends BaseCacheService implements PrizeBO {
    @Autowired
    private RemoteAlipayService remoteAlipayService;

    @Autowired
    private ActivityOrderService activityOrderService;


    @Override
    public boolean submitBillPrize(BillReq billReq,String deviceId) {
        RechargeReq rechargeReq = new RechargeReq(billReq.getOrderId(), deviceId, ActivityOptionType.TYPE_BILL);
        rechargeReq.setAccount(billReq.getAccount());
        return this.remoteAlipayService.recharge(rechargeReq);
    }

    @Override
    public void updatePrizeOrderSuccess(String orderId) {
        this.remoteAlipayService.updateQBOrderSuccess(orderId);
    }

    @Override
    public void updatePrizeOrderfailed(String orderId, String code, String msg) {
        AlipayOrderDto dto = new AlipayOrderDto();
        dto.setOrderId(orderId);
        dto.setResultMsg(msg);
        dto.setResultCode(code);
        this.remoteAlipayService.updateAlipayOrderByOrderId(dto);
    }

    @Override
    public boolean submitPhysicalInfo(PhysicalReq req) {
        AlipayOrderDto order = this.activityOrderService.selectAlipayOrder(req.getOrderId());
        if (order == null) {
            return false;
        }

        String deviceId = RequestLocal.get().getDeviceId();
        if (!StringUtils.equals(deviceId, order.getDeviceId())) {
            return false;
        }

        String day = DateUtils.getDayStr(new Date());
        String key = CachedKeyUtils.getRedisKey(CacheKey.PHYSICAL_ACCOUNT, order.getPrizeId(), req.getPhoneNumber(), day);
        String startOrderId = this.advancedCacheClient.getWithCacheLoader(key, 1, TimeUnit.DAYS, () -> req.getOrderId());

        if (!startOrderId.equals(req.getOrderId())) {
            //同样帐号同一奖项同一天 重复领奖
            List<String> orders = Lists.newArrayList(startOrderId, req.getOrderId());
            this.remoteAlipayService.updateOrderRepeat(orders);
        }

        return this.activityOrderService.submitPhysicalInfo(req);
    }
}
