package com.duiba.tuia.youtui.web.bo.impl;

import com.duiba.tuia.youtui.web.bo.AdvertBO;
import com.duiba.tuia.youtui.web.constant.Constants;
import com.duiba.tuia.youtui.web.exception.ActivityException;
import com.duiba.tuia.youtui.web.model.req.DoJoinActivityReq;
import com.duiba.tuia.youtui.web.model.req.WebShowClickLogReq;
import com.duiba.tuia.youtui.web.service.ActivityOrderService;
import com.duiba.tuia.youtui.web.service.AdvertService;
import com.duiba.tuia.youtui.web.service.DirectPageSourceService;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Service;
import com.duiba.tuia.youtui.web.tool.EmbedUtil;
import com.duiba.tuia.youtui.web.tool.RequestLocal;
import com.duiba.tuia.youtui.web.tool.RequestTool;

import org.apache.commons.lang.StringUtils;

import java.util.Map;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import cn.com.duiba.tuia.activity.center.api.dto.RspOrder;
import cn.com.tuia.advert.model.DirectAdvertLogReq;

/**
 * Created by Administrator on 2017/8/6.
 */
@Service
public class AdvertBOImp implements AdvertBO{
    @Resource
    private AdvertService advertService;
    @Resource
    private ActivityOrderService activityOrderService;
    @Resource
    private DirectPageSourceService directPageSourceService;

    @Override
    public void directAdvertLog(WebShowClickLogReq req, HttpServletRequest request) throws ActivityException {
        Long appId = RequestLocal.get().getAppId();
        Long consumerId = RequestLocal.get().getCid();
        String agent = RequestTool.getUserAgent(request);
        String ua = RequestTool.getUA(agent);
        String ip = RequestTool.getIpAddr(request);
        String os = RequestTool.getOSNew(request);
        String orderId;

        // 生成活动订单
        DoJoinActivityReq doJoinActivityReq = new DoJoinActivityReq();
        doJoinActivityReq.setAppId(appId);
        doJoinActivityReq.setConsumerId(consumerId);

        Map<String,String> map = Maps.newHashMap();
        map.put("effectiveMainType",request.getParameter("effectiveMainType"));
        map.put("advertId",String.valueOf(req.getAdvertId()));
        doJoinActivityReq.setParamMap(map);
        RspOrder order = activityOrderService.createOrderForDirectPage(doJoinActivityReq);
        orderId = Constants.THE_PREFIX_DIRECT + order.getOrderId();

        //放到req 回传到上一层
        req.setOrderId(orderId);

        // 发送日志
        DirectAdvertLogReq log = new DirectAdvertLogReq();
        log.setIp(ip);
        log.setOs(os);
        if (StringUtils.isNotBlank(agent)) {
            log.setUserAgent(agent.length() > 255 ? agent.substring(0, 255) : agent);
        }
        log.setUrl(request.getRequestURL().toString());
        log.setAppId(appId);
        log.setConsumerId(consumerId);
        log.setPageId(req.getPageId());
        log.setAdvertId(req.getAdvertId());
        log.setActivityOrderId(orderId);
        log.setUa(ua);
        log.setDeviceId(req.getDeviceId());
        log.setSlotId(req.getSlotId());
        log.setTimestamp(System.currentTimeMillis());
        log.setOrientationId(req.getPackageId());


        Map<String,String> extLog = RequestLocal.get().getCollParams();
        // 保存dcm  dpm dsm
        EmbedUtil.setDcmAndDpmAndDsmFromParam(request, extLog);
        Long directpage = directPageSourceService.get(consumerId);
        if(directpage!=null){
            extLog.put("directpage",String.valueOf(directpage));
        }
        log.setLogExtMap(extLog);

        this.advertService.directAdvertLog(log);
    }
}
