/**
 * Project Name:tuia-youtui-web<br>
 * File Name:MainMeetBO.java<br>
 * Package Name:com.duiba.tuia.youtui.web.bo<br>
 * Date:2017年3月3日上午11:28:26<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */

package com.duiba.tuia.youtui.web.bo;

import com.alibaba.fastjson.JSONObject;
import com.duiba.tuia.youtui.web.exception.ActivityException;
import com.duiba.tuia.youtui.web.model.UserAccount;
import com.duiba.tuia.youtui.web.model.req.DirectPageReq;
import com.duiba.tuia.youtui.web.model.req.IndexReq;
import com.duiba.tuia.youtui.web.model.rsp.DirectBlockRsp;
import com.duiba.tuia.youtui.web.model.rsp.DirectPageRsp;
import com.duiba.tuia.youtui.web.model.rsp.GameHallAnnouncementRsp;
import com.duiba.tuia.youtui.web.model.rsp.GetActivitysRsp;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * ClassName: MainMeetBO <br/>
 * date: 2017年3月3日 上午11:28:26 <br/>
 * .
 *
 * @author youhaijun
 * @version
 * @since JDK 1.6
 */
public interface MainMeetBO {

    /**
     * 初始化主会场.
     *
     * @param request the request
     * @return the model and view
     * @throws ActivityException the activity exception
     */
    ModelAndView index(HttpServletRequest request, IndexReq req, UserAccount consumer) throws ActivityException;

    /**
     * 获取推荐给活动中心的活动列表.
     *
     * @param num the num
     * @param request the request
     * @return the activity4 act center
     * @throws ActivityException the activity exception
     */
    GetActivitysRsp getActivity4ActCenter(IndexReq indexReq, Integer num, HttpServletRequest request)
                                                                                                       throws ActivityException;

    /**
     * 获取活动中心的广告点击跳转次数
     *
     * @param request the request
     * @throws ActivityException the activity exception
     */
    JSONObject getAdvertCounts(HttpServletRequest request)throws ActivityException;

    DirectPageRsp getAdvert(HttpServletRequest request, DirectPageReq req) throws ActivityException;


    /**
     * 创建直投页广告券rsp信息
     * @param map
     * @param appId
     * @param directPageId
     * @param consumerId
     * @param host
     * @param dsm
     */
    void buildAdvertRspForEmbed(Map<String,String> map, Long appId, Long directPageId, Long consumerId, String host,String dsm);

    /**
     * 构建广告埋点
     * @param map
     * @param appId
     * @param directPageId
     * @param consumerId
     * @param host
     * @param dpm
     * @param dcm
     * @param dsm
     */
    void buildAdvertRspForEmbed(Map<String,String> map, Long appId, Long directPageId,Long consumerId,
                                String host,String dpm,String dcm,String dsm, Long directPage);

    void buildAdvertRspForEmbed(Map<String,String> map, Long appId, Long directPageId,Long consumerId,
                                String host,String dpm,String dsm,Long directPage);


    /**
     * 根据前端传回来的postion，以及顺序位置获取对应的前端位置
     * @param positon
     * @param index
     * @author zhouwb
     * @return
     * @date 20170806
     */
    Integer[] getDirectPageDpmcAndDpmd(String positon,int index);

    /**
     * 直投页区块信息查询
     * @param request request
     * @return DirectBlockRsp
     * @throws ActivityException
     */
    DirectBlockRsp getDirectBlock(HttpServletRequest request,DirectPageReq req,boolean limitTimes) throws ActivityException;

    /**
     * 直投页区块信息查询
     *
     * 产品喜欢重新定义区块
     */
    DirectBlockRsp getDirectBlockNew(HttpServletRequest request, DirectPageReq req) throws ActivityException;

    /**
     * 获取活动中心链接
     *
     * @param request
     * @return
     */
    String getActCenterUrl(HttpServletRequest request, IndexReq req) throws ActivityException;

    Map<String, String> buildWalletEmbed(String dsm, Long appId, Long pageId, Long userId,String host);

    Map<String, String> buildGameHallEmbed(String dsm, Long appId, Long userId, String host);

    JSONObject buildNewGameHallEmbed(String dsm, Long appId, Long userId, String host,Long pageId);

    Map<String,GameHallAnnouncementRsp> getAnnouncement();

}
