package com.duiba.tuia.youtui.web.service;

import com.duiba.tuia.youtui.web.TransactionalTestCaseBase;
import com.duiba.tuia.youtui.web.model.UserAccount;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.util.UUID;

/**
 * Created by houwen on 27/07/2017.
 */
public class ConsumerServiceTest extends TransactionalTestCaseBase{

    @Autowired
    @Qualifier("consumerServiceImpl")
    private ConsumerService consumerService;

    @Test
    public void testGetOrMakeUser() throws  Exception{
        Long appId = System.currentTimeMillis();
        String partentUserId = UUID.randomUUID().toString().replace("-","");
        UserAccount ua = consumerService.getOrMakeUser(appId, partentUserId);
        Assert.assertNotNull(ua != null);
        Assert.assertTrue(ua.getUserId() != null);
        Long userID = ua.getUserId();
        UserAccount ua2 = consumerService.getOrMakeUser(appId, partentUserId);
        Assert.assertTrue(ua2.getUserId().equals(userID));
    }
}
