package com.duiba.tuia.youtui.web;

import org.junit.runner.RunWith;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;

/**
 * 所有数据库相关测试类(dao/service层)都应该继承此类, 每个测试方法执行后所有数据库操作都会自动回滚 可以在子类上加上注解@TransactionConfiguration(defaultRollback =
 * false)禁止自动回滚 或者在子类的某个测试方法上加上注解@Rollback(false)来禁止该方法的自动回滚 Created by wenqi.huang on 16/4/11.
 */
@RunWith(SpringJUnit4ClassRunner.class)
@WebAppConfiguration
@TestPropertySource(properties="spring.config.location=http://dev.config.duibar.com:1024/tuia-youtui-web-dev.properties")
@ActiveProfiles("noRegister")//noRegister 不注册dubbo服务，单元测试时不需要，开发时也可以在启动参数加入-Dspring.profiles.active=noRegister加快启动速度
public abstract class TransactionalTestCaseBase { //extends AbstractTransactionalJUnit4SpringContextTests

}
