/**
 * Copyright (c) 2018, duiba.com.cn All Rights Reserved.
 */
package com.duiba.tuia.youtui.web.tool;

/**
 * 描述: 分流器
 *
 * @version v1.0
 * @auther guopengfei@duiba.com.cn
 * @date 2018/4/16 14:19
 */
public class StyleTypeUtil {

    private static final Long HALF_FACTOR = 1260L;

    private static final Long QUARTER_FACTOR = 630L;

    private StyleTypeUtil() {
    }

    public static Long half(Long styleType) {
        if (styleType == null) {
            return 1L;
        }
        return (styleType - 1) / HALF_FACTOR + 1L;
    }

    public static Long quarter(Long styleType) {
        if (styleType == null) {
            return 1L;
        }
        return (styleType - 1) / QUARTER_FACTOR + 1L;
    }
}
