package com.duiba.tuia.youtui.web.tool;


/**
 * The Class SecureTool.
 */
public class SecureTool {
	
	/** The consumer key. */
	private static String consumerKey;
	
	/**
	 * The Constructor.
	 */
	private SecureTool(){
	    
	}

	
	/**
	 * Decrypt consumer cookie.
	 *
	 * @param data the data
	 * @return the string
	 */
	public static String decryptConsumerCookie(String data){
		return BlowfishUtils.decryptBlowfish(data, consumerKey);
	}
	
	/**
	 * 加密.
	 *
	 * @param data the data
	 * @return the string
	 */
	public static String encryptConsumerCookie(String data){
        return BlowfishUtils.encryptBlowfish(data, consumerKey);
    }
	
	/**
	 * Sets the consumer key.
	 *
	 * @param consumerKey the consumer key
	 */
	public static void setConsumerKey(String consumerKey) {
		SecureTool.consumerKey = consumerKey;
	}


}
