/**
 * 文件名： ResultPageUtils.java 此类描述的是： 作者: leiliang 创建时间: 2016年3月23日 上午10:59:14
 */
package com.duiba.tuia.youtui.web.tool;

import java.util.List;

import com.duiba.tuia.youtui.web.constant.ErrorCode;
import com.duiba.tuia.youtui.web.model.Result;
import com.duiba.tuia.youtui.web.model.ResultPage;

/**
 * 构造返回结果工具类 .
 *
 * @author: leiliang
 * @version:
 */
public class ResultUtil {

    /**
     * The Constructor.
     */
    private ResultUtil() {
    }

    /**
     * 构造一个失败的返回结果.
     *
     * @param <T> the generic type
     * @param errorCode 错误码
     * @param desc 错误描述
     * @return 失败的返回结果
     */
    public static <T> Result<T> fail(String errorCode, String desc) {
        Result<T> result = new Result<>();
        result.setCode(errorCode);
        result.setDesc(desc);
        result.setSuccess(false);
        return result;
    }

    /**
     * 构造一个失败的返回结果.
     *
     * @param <T> the generic type
     * @param code 错误码枚举
     * @return the error result do
     */
    public static <T> Result<T> fail(ErrorCode code) {
        Result<T> result = new Result<>();
        result.setCode(code.geteCode());
        result.setDesc(code.geteDesc());
        result.setSuccess(false);
        return result;
    }

    /**
     * <一句话功能描述>.
     *
     * @param <T> the generic type
     * @param t the t
     * @return the result< t>
     */
    public static <T> Result<T> success(T t) {
        Result<T> result = new Result<>();
        result.setCode(ErrorCode.E0000000.geteCode());
        result.setData(t);
        result.setDesc(ErrorCode.E0000000.geteDesc());
        result.setSuccess(true);
        return result;
    }

    /**
     * <一句话功能描述>.
     *
     * @param <T> the generic type
     * @return the result< t>
     */
    public static <T> Result<T> success() {
        Result<T> result = new Result<>();
        result.setCode(ErrorCode.E0000000.geteCode());
        result.setDesc(ErrorCode.E0000000.geteDesc());
        result.setSuccess(true);
        return result;
    }

    /**
     * 构造一个成功的返回结果(数据为列表).
     *
     * @param <T> the generic type
     * @param count 总数
     * @param list 列表数据
     * @return ResultDO 对象(数据为列表)
     */
    public static <T> ResultPage<T> success(long count, List<T> list) {
        ResultPage<T> result = new ResultPage<>();
        result.setCode(ErrorCode.E0000000.geteCode());
        result.setData(list);
        result.setCount(count);
        result.setSuccess(true);
        return result;
    }
}
