/**
 * 文件名： JsonUtils.java 此类描述的是： 作者: leiliang 创建时间: 2016年3月23日 上午10:48:33
 */
package com.duiba.tuia.youtui.web.tool;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletResponse;

import com.duiba.tuia.youtui.web.exception.ActivityRuntimeException;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;

/**
 * ClassName: JsonUtils <br/>
 * date: 2016年7月13日 上午9:57:39 <br/>
 *
 * @author zp
 * @version
 * @since JDK 1.6
 */
public class JsonUtils {

    public static final ObjectMapper mapper     = new ObjectMapper();
    
    static {
        //创建输出全部属性到Json字符串的Mapper.
        mapper.setSerializationInclusion(Include.ALWAYS);
    }
    
    private JsonUtils() {}

    /**
     * 对象转JSON
     * 
     * @param response
     * @param obj
     */
    public static void objToJSON(HttpServletResponse response, final Object obj) {
        try {
            setResponse(response);
            PrintWriter out = response.getWriter();
            out.print(objectToString(obj));
            out.close();
        } catch (IOException e) {
            throw new ActivityRuntimeException(e);
        }
    }

    /**
     * 如果对象为Null, 返回"null". 如果集合为空集合, 返回"[]".
     * 
     * @param obj
     * @return
     */
    public static String objectToString(Object obj) {
        try {
            return mapper.writeValueAsString(obj);
        } catch (Exception e) {
            throw new ActivityRuntimeException(e);
        }
    }

    /**
     * 如果JSON字符串为Null或"null"字符串, 返回Null. 如果JSON字符串为"[]", 返回空集合. 如需读取集合如List/Map,
     * 且不是List<String>这种简单类型时,先使用函數constructParametricType构造类型.
     * 
     * @see #constructParametricType(Class, Class...)
     * @param clazz
     * @param json
     * @return
     */
    public static <T> T jsonToObject(Class<T> clazz, String json) {
        if (isEmpty(json)) {
            return null;
        }
        try {
            return mapper.readValue(json, clazz);
        } catch (Exception e) {
            throw new ActivityRuntimeException(e);
        }
    }

    /**
     * 
     * parseJsonToObject:(这里用一句话描述这个方法的作用). <br/>
     * @param json
     * @param typeReference
     * @return
     * @since JDK 1.6
     */
    public static <T> T parseJsonToObject(String json, TypeReference<T> typeReference) {
        T result = null;
        try {
            result = mapper.readValue(json, typeReference);
        } catch (IOException e) {
            throw new ActivityRuntimeException(e);
        }
        return result;
    }

    public static <T> List<T> jsonToList(String jsonData, Class<T> beanType) {
        JavaType javaType = mapper.getTypeFactory().constructParametricType(List.class, beanType);
        try {
            return mapper.readValue(jsonData, javaType);
        } catch (Exception e) {
            return new ArrayList<>();
        }
    }

    /**
     * 设置编码格式
     * 
     * @param response
     */
    public static void setResponse(HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html");
    }

    private static boolean isEmpty(String str) {
        return str == null ? true : "".equals(str.trim());
    }
}
