package com.duiba.tuia.youtui.web.tool;/**
 * Created by chengdeman .
 * 17/5/7 .
 */


import java.util.concurrent.ExecutorService;

import javax.annotation.Resource;

/**
 * 统一线程池调度
 *
 * @author chengdeman
 * @create 2017-05-07 下午9:47
 **/
public class ExecutorServiceUtils{


    @Resource
    private ExecutorService executorService;        // 定义线程池，异步化参加活动流程

    //定义一个静态私有变量
    private static volatile ExecutorServiceUtils instance;
    
    
    public  ExecutorService  executorService2() {
        return executorService;
    }


    /**
     * @Description :  共用线程池具体执行任务方法
     * @param : task 执行任务
     * @return :  返回值
     * @author :  chengdeman
     * @Date :  17/5/
     */
    public  Boolean   runTask(Runnable task){

        if(task == null){
            return  false ;
        }
        // 线程池攻击提交task
        executorService.submit(task);

        return  true;
    }


    private ExecutorServiceUtils() {

    }


    //单例一下
    public static ExecutorServiceUtils getIstance() {
        if (instance == null) {
            synchronized (ExecutorServiceUtils.class) {
                if (instance == null) {
                    instance = new ExecutorServiceUtils();
                }
            }
        }
        return instance;
    }

}
