package com.duiba.tuia.youtui.web.tool;

import cn.com.duiba.wolf.utils.UrlUtils;
import com.duiba.tuia.youtui.web.constant.Constants;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created by zhou_wb on 2017/8/4.
 * dsm 信息填充
 */
public class DsmInfo {
    /**
     * The Constant logger.
     */
    protected static final Logger logger = LoggerFactory.getLogger(DpmInfo.class);

    /**
     * The Constructor.
     */
    private DsmInfo() {
    }

    public static String dsmInfo(int dsm1, int dpm2, int dsm3, Long dsm4) {
        return new StringBuilder().append(dsm1).append(Constants.DPM.DPM_SPLIT).append(dpm2).append(Constants.DPM.DPM_SPLIT).append(dsm3).append(Constants.DPM.DPM_SPLIT).append(dsm4).toString();
    }

    public static String dsmInfo(String dsm1, String dpm2, int dsm3, Long dsm4) {
        return new StringBuilder().append(dsm1).append(Constants.DPM.DPM_SPLIT).append(dpm2).append(Constants.DPM.DPM_SPLIT).append(dsm3).append(Constants.DPM.DPM_SPLIT).append(dsm4).toString();
    }

    /***
         * @Description: getDsmFromDsm 依据dsm中ab两位获取新的dsm
         *
         * @Param: [dsm, dsm3, dsm4]
         * @Return: java.lang.String
         * @throws:
         * @author: youhaijun
         * @Date:   2017/9/4
         */
    public static String getDsmFromDsm(String dsm, int dsm3, Long dsm4) {
        String dsmA = getParamFromDsm(dsm, 1);
        String dsmB = getParamFromDsm(dsm, 2);
        return dsmInfo(dsmA, dsmB, dsm3, dsm4);
    }

    /**
     * 从Dsm中获取参数.
     *
     * @param dsm the dsm
     * @param index the index
     * @return the long from dsm
     */
    public static String getParamFromDsm(String dsm, int index) {
        if (StringUtils.isEmpty(dsm) || index > 4 || index <= 0) {
            return StringUtils.EMPTY;
        }
        String[] s1 = StringUtils.split(dsm, ".");
        return s1[index - 1];
    }

    public static String getDsmFromUrl(String url) {
        String dsm = null;
        if (StringUtils.isNotBlank(url)) {
            dsm = UrlUtils.uRLRequest(url).get(Constants.KEY.DSM);
        }
        return dsm;
    }

}
