/*
 * 
 */
package com.duiba.tuia.youtui.web.tool;

import cn.com.duiba.tuia.activity.center.api.constant.FieldNameSpace;
import cn.com.duiba.tuia.activity.center.api.dto.AlipayOrderDto;
import com.alibaba.fastjson.JSONObject;
import com.duiba.tuia.youtui.web.constant.Constants;
import com.duiba.tuia.youtui.web.constant.DeliveryType;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * ClassName:DpmInfo.java <br/>
 *
 * @author gey
 * @version 1.0
 * @date 创建时间：2017年1月13日 下午4:06:17
 * @parameter
 * @since JDK 1.6
 */
public class DpmInfo {

    /**
     * The Constant logger.
     */
    protected static final Logger logger = LoggerFactory.getLogger(DpmInfo.class);

    /**
     * The Constructor.
     */
    private DpmInfo() {
    }

    /**
     * dpmInfo.
     *
     * @param url the URL
     * @param appId the app id
     * @param dpm1 the dpm1
     * @param dpm2 the dpm2
     * @param dpm3 the dpm3
     * @return the string
     * @since JDK 1.6
     */
    public static String dpmInfo(String url, Long appId, int dpm1, int dpm2, int dpm3) {
        if (url.contains("?")) {
            return url + "&dpm=" + appId + Constants.DPM.DPM_SPLIT + dpm1 + Constants.DPM.DPM_SPLIT + dpm2
                    + Constants.DPM.DPM_SPLIT + dpm3;
        } else {
            return url + "?dpm=" + appId + Constants.DPM.DPM_SPLIT + dpm1 + Constants.DPM.DPM_SPLIT + dpm2
                    + Constants.DPM.DPM_SPLIT + dpm3;
        }
    }

    /**
     * 获取广告券曝光埋点信息.
     *
     * @param appId      the app id
     * @param consumerId the consumer id
     * @param orderId    the order id
     * @param advertId   the advert id
     * @param materialId the material id
     * @param activityId the activity id
     * @param dpm        the dpm
     * @param dcm        the dcm
     * @return the string
     * @since JDK 1.6
     */
    public static String setStInfo(String host, Long appId, Long consumerId, String orderId, Long advertId, Long materialId,
                                   Long activityId, String dpm, String dcm, String dsm, Integer deliverType,
                                   String skinType, String couponSource, Integer activityType, String styleType,
                                   Long directPage) {

        JSONObject json = new JSONObject();
        json.put(Constants.VALUENAME.DOMAIN, DomainConstantUtil.getAppEmbedClickUrl());// 埋点服务器Domain
        json.put(Constants.Embed.DOMAIN_4WEB, host);
        json.put(Constants.Embed.DOMAIN_WEB, host);
        json.put(Constants.VALUENAME.URL, Constants.PATH.ACTIVITY + Constants.PATH.SHOWLOG);
        json.put(Constants.DEVICE_TYPE, "tuia");

        if (StringUtils.isNotBlank(dsm)) {
            json.put("dsm", dsm);
        }
        if (deliverType != null) {
            json.put(Constants.VALUENAME.DELIVERY_TYPE, deliverType);
        }
        json.put(Constants.VALUENAME.APP_ID, appId);
        json.put(Constants.VALUENAME.CONSUMER_ID, consumerId);
        json.put(Constants.VALUENAME.ORDER_ID, orderId);
        json.put("advertId", advertId);
        json.put("materialId", materialId);
        json.put(FieldNameSpace.ACTIVITY_ID, activityId);
        json.put(Constants.KEY.DPM, dpm);
        json.put(Constants.KEY.DCM, dcm);
        if (StringUtils.isNotBlank(skinType)) {
            json.put(Constants.VALUENAME.SKIN_TYPE, skinType);
        }
        json.put(Constants.Embed.ACTIVITY_TYPE, activityType);
        json.put("couponSource", couponSource);
        if (StringUtils.isNotBlank(styleType)) {
            json.put("styleType", styleType);
        }
        if(directPage!=null){
            json.put("directpage", directPage);
        }

        return json.toJSONString();
    }


    /**
     * 获取推荐位弹层曝光埋点.
     *
     * @param appId the app id
     * @param consumerId the consumer id
     * @param dpm the dpm
     * @return the string
     */
    public static String setStRecommendInfo(Long appId, Long consumerId, String dpm, String dcm,Long directPage) {
        JSONObject json = new JSONObject();
        json.put(Constants.VALUENAME.DOMAIN, DomainConstantUtil.getAppEmbedClickUrl());// 埋点服务器Domain

        json.put(Constants.Embed.APP_ID, appId);
        json.put(Constants.Embed.CONSUMER_ID, consumerId);
        json.put(Constants.KEY.DPM, dpm);
        if (StringUtils.isNotBlank(dcm)){
            json.put(Constants.KEY.DCM, dcm);
        }
        if(directPage!=null){
            json.put("directpage",directPage);
        }
        return json.toJSONString();
    }

    /**
     * 获取浮标曝光埋点.
     *
     * @param appId the app id
     * @param consumerId the consumer id
     * @param dpm the dpm
     * @return the string
     */
    public static String setStBuoyInfo(Long appId, Long consumerId, String host, String dpm) {
        JSONObject json = new JSONObject();
        json.put(Constants.VALUENAME.DOMAIN, DomainConstantUtil.getAppEmbedClickUrl());// 埋点服务器Domain

        json.put(Constants.Embed.APP_ID, appId);
        json.put(Constants.Embed.CONSUMER_ID, consumerId);
        json.put(Constants.KEY.DPM, dpm);
        
        json.put(Constants.Embed.DOMAIN_WEB, host);
        return json.toJSONString();
    }


    /**
     * 插件工具曝光埋点.
     *
     * @param dpm the dpm
     * @param dcm the dcm
     * @return the string
     */
    public static String setStPluginInfo(Long appId, Long consumerId, String dpm, String dcm, String host, Long directPage) {
        JSONObject json = new JSONObject();
        json.put(Constants.VALUENAME.DOMAIN, DomainConstantUtil.getAppEmbedClickUrl());// 埋点服务器Domain
        json.put(Constants.Embed.DOMAIN_WEB, host);
        json.put(Constants.Embed.APP_ID, appId);
        json.put(Constants.Embed.CONSUMER_ID, consumerId);
        json.put(Constants.KEY.DPM, dpm);
        json.put(Constants.KEY.DCM, dcm);
        if(directPage!=null){
            json.put("directpage",directPage);
        }
        return json.toJSONString();
    }

    /**
     * 插件工具点击埋点.
     *
     * @param dpm the dpm
     * @param dcm the dcm
     * @return the string
     */
    public static String setStPluginClick(Long appId, Long consumerId, String host, String dpm, String dcm,Long directPage) {
        JSONObject json = new JSONObject();
        json.put(Constants.Embed.DOMAIN_4WEB, host);

        json.put(Constants.Embed.APP_ID, appId);
        json.put(Constants.VALUENAME.URL, Constants.PATH.STATISTICS + Constants.PATH.CLICK);
        json.put(Constants.Embed.CONSUMER_ID, consumerId);
        json.put(Constants.KEY.DPM, dpm);
        json.put(Constants.KEY.DCM, dcm);
        if(directPage!=null){
            json.put("directpage",directPage);
        }
        return json.toJSONString();
    }
    
    /**
     * 获取推荐位弹层曝光埋点.
     *
     * @param appId the app id
     * @param consumerId the consumer id
     * @param orderId the order id
     * @param activityId the activity id
     * @param buoyId the buoy id
     * @param dpm the dpm
     * @param dcm the dcm
     * @return the string
     */
    public static String setStRecommendInfo(Long appId, Long consumerId, String dpm) {
        JSONObject json = new JSONObject();
        json.put("domain", DomainConstantUtil.getAppEmbedClickUrl());// 埋点服务器Domain

        json.put("appId", appId);
        json.put("consumerId", consumerId);
        json.put("dpm", dpm);
        return json.toJSONString();
    }

    /**
     * getDpmInfo.
     *
     * @param appId the app id
     * @param dpm1 the dpm1
     * @param dpm2 the dpm2
     * @param dpm3 the dpm3
     * @return the dpm info
     * @since JDK 1.6
     */
    public static String getDpmInfo(Long appId, int dpm1, int dpm2, int dpm3) {
        return appId + Constants.DPM.DPM_SPLIT + dpm1 + Constants.DPM.DPM_SPLIT + dpm2
                + Constants.DPM.DPM_SPLIT + dpm3;
    }

    /**
     * getDcmInfo.
     *
     * @param advertId the advert id
     * @param materialId the material id
     * @return the dcm info
     * @since JDK 1.6
     */
    public static String getDcmInfo(Long advertId, Long materialId) {
        if (null == advertId) {
            logger.warn("构造dcm参数为空，请检查advertId={}", advertId);
            return null;
        }
        return Constants.DCM.DCM_A_104 + Constants.DPM.DPM_SPLIT + advertId + Constants.DPM.DPM_SPLIT
                + Constants.DCM.DCM_B_0 + Constants.DPM.DPM_SPLIT + (null == materialId ? -1 : materialId);
    }

    /**
     * getDcmThanksInfo.
     *
     * @param advertId the advert id
     * @param materialId the material id
     * @return the dcm info
     * @since JDK 1.6
     */
    public static String getThanksDcmInfo(Long advertId, Long materialId, Long layerId) {
        if (null == advertId) {
            logger.warn("构造dcm参数为空，请检查advertId={}", advertId);
            return null;
        }
        return Constants.DCM.DCM_A_104 + Constants.DPM.DPM_SPLIT + advertId + Constants.DPM.DPM_SPLIT
                + layerId + Constants.DPM.DPM_SPLIT + (null == materialId ? -1 : materialId);
    }


    /**
     * getDcmInfo.
     *
     * @return the dcm info
     * @since JDK 1.6
     */
    public static String dcmInfo(int dcm0, Long dcm1, int dcm2, Long dcm3) {
        return dcm0 + Constants.DPM.DPM_SPLIT + dcm1 + Constants.DPM.DPM_SPLIT + dcm2
                + Constants.DPM.DPM_SPLIT + dcm3;
    }

    /**
     * 从Dcm中获取参数.
     *
     * @param dcm the dcm
     * @param index the index
     * @return the long from dcm
     */
    public static String getParamFromDcm(String dcm, int index) {
        if (StringUtils.isEmpty(dcm) || index > 4) {
            return StringUtils.EMPTY;
        }
        int a = 0;
        for (int i = 1; i < index; i++) {
            a = dcm.indexOf(Constants.DPM.DPM_SPLIT, a + 1);
        }
        int b = dcm.indexOf(Constants.DPM.DPM_SPLIT, a + 1);
        return dcm.substring(a + 1, b < 0 ? dcm.length() : b);
    }

    /**
     * 获取广告券点击埋点信息.
     *
     * @param appId the app id
     * @param consumerId the consumer id
     * @param orderId the order id
     * @param advertId the advert id
     * @param materialId the material id
     * @param activityId the activity id
     * @param dpm the dpm
     * @param dcm the dcm
     * @return the string
     * @since JDK 1.6
     */
    public static String setClickInfo(String host, Long appId, Long consumerId, String orderId, Long advertId, Long materialId,
                                      Long activityId, String dpm, String dcm, String dsm, Integer deliveryType,
                                      String skinType , Integer activityType, String styleType,
                                      Long directPage) {

        JSONObject json = new JSONObject();
        json.put(Constants.VALUENAME.DOMAIN, DomainConstantUtil.getAppEmbedClickUrl());// 埋点服务器Domain
        json.put(Constants.Embed.DOMAIN_4WEB, host);// 埋点服务器Domain
        json.put(Constants.VALUENAME.URL, Constants.PATH.STATISTICS + Constants.PATH.CLICK);
        json.put(Constants.DEVICE_TYPE, "tuia");
        if (StringUtils.isNotBlank(dsm)) {
            json.put("dsm", dsm);
        }
        if (deliveryType != null) {
            json.put(Constants.VALUENAME.DELIVERY_TYPE, deliveryType);
        }

        json.put(Constants.VALUENAME.APP_ID, appId);
        json.put(Constants.VALUENAME.CONSUMER_ID, consumerId);
        json.put(Constants.VALUENAME.ORDER_ID, orderId);
        json.put("advertId", advertId);
        json.put("materialId", materialId);
        json.put(FieldNameSpace.ACTIVITY_ID, activityId);
        json.put(Constants.KEY.DPM, dpm);
        json.put(Constants.KEY.DCM, dcm);
        if (StringUtils.isNotBlank(skinType)) {
            json.put(Constants.VALUENAME.SKIN_TYPE, skinType);
        }
        json.put(Constants.Embed.ACTIVITY_TYPE, activityType);
        if (StringUtils.isNotBlank(styleType)) {
            json.put("styleType", styleType);
        }
        if(directPage!=null){
            json.put("directpage",directPage);
        }


        return json.toJSONString();
    }

    /**
     * getDcmInfo.
     * 内容位置埋点，c为带有皮肤Id
     *
     * @return the dcm info
     * @since JDK 1.6
     */
    public static String dcmClickInfo(int dcm0, Long dcm1, String dcm2, Long dcm3) {
        return dcm0 + Constants.DPM.DPM_SPLIT + dcm1 + Constants.DPM.DPM_SPLIT + dcm2
                + Constants.DPM.DPM_SPLIT + dcm3;
    }

    /**
     * 支付宝直充弹层通用埋点信息
     *
     * @param appId appId
     * @param consumerId 用户id
     * @param alipayOrderDto 奖品订单
     * @param dsm dsm
     * @return
     */
    public static JSONObject setCommonEmbedForAliPay(Long appId, Long consumerId, AlipayOrderDto alipayOrderDto, String dsm) {
        JSONObject json = new JSONObject();
        json.put(Constants.DEVICE_TYPE, "tuia");
        if (StringUtils.isNotBlank(dsm)) {
            json.put("dsm", dsm);
        }
        json.put(Constants.VALUENAME.APP_ID, appId);
        json.put(Constants.VALUENAME.CONSUMER_ID, consumerId);
        json.put(Constants.VALUENAME.ORDER_ID, alipayOrderDto.getOrderId());
        json.put(FieldNameSpace.ACTIVITY_ID, alipayOrderDto.getActivityId());
        json.put("slotId", alipayOrderDto.getSlotId());
        json.put(Constants.Embed.ACTIVITY_TYPE, alipayOrderDto.getActivityType());
        return json;
    }

    /**
     * 支付宝直充弹层点击埋点信息
     *
     * @param dpm
     * @param dcm
     * @return
     * @author zhou_wb
     * @date 2017/07/12
     * @version 1.0
     */
    public static String setClickInfoEmbedForAliPay(JSONObject jsonObject, String host, String dpm, String dcm) {
        JSONObject json = new JSONObject();
        json.put(Constants.Embed.DOMAIN_4WEB, host);
        json.put(Constants.VALUENAME.URL, Constants.PATH.STATISTICS + Constants.PATH.CLICK);
        json.putAll(jsonObject);
        json.put(Constants.KEY.DPM, dpm);
        if (StringUtils.isNotBlank(dcm)) {
            json.put(Constants.KEY.DCM, dcm);
        }
        return json.toJSONString();
    }

    /**
     * 谢谢参与我的奖品页list点击
     *
     * @param dpm
     * @param dcm
     * @return
     * @author cdm
     * @date 2017/07/12
     * @version 1.0
     */
    public static String setClickForThaks(String host, String dpm, String dcm) {
        JSONObject json = new JSONObject();
        json.put(Constants.Embed.DOMAIN_4WEB, host);
        json.put(Constants.VALUENAME.URL, Constants.PATH.STATISTICS + Constants.PATH.CLICK);
        json.put(Constants.KEY.DPM, dpm);
        json.put(Constants.KEY.DCM, dcm);
        return json.toJSONString();
    }

    /**
     * 谢谢参与我的奖品页list曝光
     *
     * @param dpm
     * @param dcm
     * @return
     * @author cdm
     * @date 2017/07/12
     * @version 1.0
     */
    public static String setExposureForThanks(String host, String dpm, String dcm) {
        JSONObject json = new JSONObject();
        json.put(Constants.Embed.DOMAIN_WEB, host);
        json.put(Constants.VALUENAME.URL, Constants.PATH.THANKS_RECOMMED);
        json.put(Constants.KEY.DPM, dpm);
        json.put(Constants.KEY.DCM, dcm);
        return json.toJSONString();
    }

    /**
     * 支付宝直充弹层曝光埋点信息
     *
     * @param jsonObject
     * @param host
     * @param dpm
     * @param dcm
     * @return
     */
    public static String setExposureEmbedForAliPay(JSONObject jsonObject, String host, String dpm, String dcm) {
        JSONObject json = new JSONObject();
        json.put(Constants.VALUENAME.DOMAIN, DomainConstantUtil.getAppEmbedClickUrl());
        json.putAll(jsonObject);
        json.put(Constants.KEY.DPM, dpm);
        if (StringUtils.isNotBlank(dcm)) {
            json.put(Constants.KEY.DCM, dcm);
        }
        return json.toJSONString();
    }

    /**
     * 直投通用埋点
     *
     * @param appId
     * @param consumerId
     * @return
     */
    public static JSONObject setCommonEmbedForDirectPage(Long appId, Long consumerId) {
        JSONObject json = new JSONObject();
        json.put(Constants.VALUENAME.APP_ID, appId);
        json.put(Constants.VALUENAME.CONSUMER_ID, consumerId);
        json.put(Constants.VALUENAME.DELIVERY_TYPE, DeliveryType.DIRECT_PAGE.getType());
        return json;

    }


    /**
     * 直投页券曝光
     *
     * @param json
     * @param host
     * @param dcm
     * @param dpm
     * @param dsm
     * @return
     * @author zhou_wb
     * @date 2017-08-04
     */
    public static String setExposureEmbedForDirectPageLaunch(JSONObject json, String host, String dcm, String dpm, String dsm, Long directPage) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.putAll(json);
        jsonObject.put(Constants.KEY.DCM, dcm);
        jsonObject.put(Constants.KEY.DPM, dpm);
        jsonObject.put("dsm", dsm);
        jsonObject.put(Constants.VALUENAME.DOMAIN, DomainConstantUtil.getAppEmbedClickUrl());// 埋点服务器Domain
        return jsonObject.toJSONString();
    }

    /**
     * 直投变现页活动与自定义链接入口曝光
     *
     * @param json
     * @param dcm
     * @param dpm
     * @param dsm
     * @return
     * @date 2017-08-04
     */
    public static String setExposureEmbedForDirectPage(JSONObject json, String dcm, String dpm, String dsm,Long directPage) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.putAll(json);
        if (StringUtils.isNotBlank(dcm)) {
            jsonObject.put(Constants.KEY.DCM, dcm);
        }
        jsonObject.put(Constants.KEY.DPM, dpm);
        jsonObject.put("dsm", dsm);
        jsonObject.put(Constants.VALUENAME.DOMAIN, DomainConstantUtil.getAppEmbedClickUrl());// 埋点服务器Domain
        if(directPage!=null) {
            jsonObject.put("directpage", directPage);
        }
        return jsonObject.toJSONString();
    }


    /**
     * 直投变现页活动与自定义链接入口曝光
     *
     * @param json
     * @param dsm
     * @return
     * @date 2017-08-04
     */
    public static String setExposureEmbedUrl(JSONObject json, String dsm, String dcm, String dpm) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.putAll(json);
        jsonObject.put(Constants.KEY.DCM, dcm);
        jsonObject.put(Constants.KEY.DPM, dpm);
        jsonObject.put("dsm", dsm);
        jsonObject.put(Constants.VALUENAME.DOMAIN, DomainConstantUtil.getAppEmbedClickUrl());// 埋点服务器Domain
        return jsonObject.toJSONString();
    }

    /**
     * 直投变现页活动与自定义链接入点击埋点
     *
     * @param json
     * @param dpm
     * @param dsm
     * @return
     */
    public static String setClickInfoEmbedForDirectPage(JSONObject json, String host, String dpm, String dsm,Long directPage) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.putAll(json);
        jsonObject.put(Constants.KEY.DPM, dpm);
        jsonObject.put("dsm", dsm);
        jsonObject.put(Constants.Embed.DOMAIN_4WEB, host);
        jsonObject.put(Constants.VALUENAME.URL, Constants.PATH.STATISTICS + Constants.PATH.CLICK);
        if(directPage!=null){
            jsonObject.put("directpage",directPage);
        }
        return jsonObject.toJSONString();
    }


    /**
     * 直投变现页点击埋点
     *
     * @param json
     * @param dcm
     * @param dpm
     * @param dsm
     * @return
     */
    public static String setClickInfoEmbedForDirectPage(JSONObject json, String host, String dcm, String dpm, String dsm, Long directPage) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.putAll(json);
        jsonObject.put(Constants.KEY.DCM, dcm);
        jsonObject.put(Constants.KEY.DPM, dpm);
        jsonObject.put("dsm", dsm);
        jsonObject.put(Constants.Embed.DOMAIN_4WEB, host);
        jsonObject.put(Constants.VALUENAME.URL, Constants.PATH.STATISTICS + Constants.PATH.CLICK);
        if(directPage!=null){
            json.put("directpage", directPage);
        }
        return jsonObject.toJSONString();
    }

    /**
     * 活动页曝光埋点.
     *
     * @param dpm the dpm
     * @param dcm the dcm
     * @return the string
     */
    public static String setStActivityInfo(Long appId, Long consumerId, String dpm, String dcm, String host,Long directPage) {
        JSONObject json = new JSONObject();
        json.put(Constants.Embed.APP_ID, appId);
        json.put(Constants.Embed.CONSUMER_ID, consumerId);
        json.put(Constants.KEY.DPM, dpm);
        json.put(Constants.KEY.DCM, dcm);
        json.put(Constants.VALUENAME.DOMAIN, DomainConstantUtil.getAppEmbedClickUrl());// 埋点服务器Domain
        json.put(Constants.Embed.DOMAIN_WEB, host);
        if(directPage!=null){
            json.put("directpage", directPage);
        }
        return json.toJSONString();
    }

    public static JSONObject setStActivityInfoJSON(Long appId, Long consumerId, String dpm, String dcm, String host,Long directPage) {
        JSONObject json = new JSONObject();
        json.put(Constants.Embed.APP_ID, appId);
        json.put(Constants.Embed.CONSUMER_ID, consumerId);
        json.put(Constants.KEY.DPM, dpm);
        json.put(Constants.KEY.DCM, dcm);
        json.put(Constants.VALUENAME.DOMAIN, DomainConstantUtil.getAppEmbedClickUrl());// 埋点服务器Domain
        json.put(Constants.Embed.DOMAIN_WEB, host);
        if(directPage!=null){
            json.put("directpage", directPage);
        }
        return json;
    }

    /**
     * 活动页点击埋点.
     *
     * @param dpm the dpm
     * @param dcm the dcm
     * @return the string
     */
    public static String setStActivityClick(Long appId, Long consumerId, String dpm, String dcm, String host,Long directPage) {
        JSONObject json = new JSONObject();
        json.put(Constants.Embed.APP_ID, appId);
        json.put(Constants.VALUENAME.URL, Constants.PATH.STATISTICS + Constants.PATH.CLICK);
        json.put(Constants.Embed.CONSUMER_ID, consumerId);
        json.put(Constants.KEY.DPM, dpm);
        json.put(Constants.KEY.DCM, dcm);
        json.put(Constants.Embed.DOMAIN_4WEB, host);
        if(directPage!=null){
            json.put("directpage",directPage);
        }
        return json.toJSONString();
    }

    public static JSONObject setStActivityClickJSON(Long appId, Long consumerId, String dpm, String dcm, String host) {
        JSONObject json = new JSONObject();
        json.put(Constants.Embed.APP_ID, appId);
        json.put(Constants.VALUENAME.URL, Constants.PATH.STATISTICS + Constants.PATH.CLICK);
        json.put(Constants.Embed.CONSUMER_ID, consumerId);
        json.put(Constants.KEY.DPM, dpm);
        json.put(Constants.KEY.DCM, dcm);
        json.put(Constants.Embed.DOMAIN_4WEB, host);
        return json;
    }
}
