package com.duiba.tuia.youtui.web.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.duiba.tuia.youtui.web.constant.OnsMQProperties;
import com.duiba.tuia.youtui.web.service.BaseService;
import com.duiba.tuia.youtui.web.service.RocketMQService;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.message.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Service;

import java.io.UnsupportedEncodingException;

@Service
@EnableConfigurationProperties({OnsMQProperties.class})
public class RocketMQServiceImpl extends BaseService implements RocketMQService{

    @Autowired
    private DefaultMQProducer rocketMqProducer;
    
    @Autowired
    private OnsMQProperties onsMQProperties;


    @Override
    public void sendCPAAdvertMQ(JSONObject json) {
        this.send(onsMQProperties.getTopic().getRoiCvr(),"cvr",json.toJSONString());
    }

    @Override
    public void send(String topic, String tag, String message) {
        try {
            Message msg = new Message(topic, tag, message.getBytes("UTF-8"));
            // 设置代表消息的业务关键属性，请尽可能全局唯一，以方便您在无法正常收到消息情况下，可通过MQ控制台查询消息并补发
            // 注意：不设置也不会影响消息正常收发
            msg.setKeys("taw-rocket");
            this.rocketMqProducer.sendOneway(msg);
        } catch (UnsupportedEncodingException e) {
            logger.error("", e);
        } catch (Exception e) {
            logger.warn("发消息异常,topic=" + topic, e);
        }
    }


}
