package com.duiba.tuia.youtui.web.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.alibaba.fastjson.JSONObject;
import com.duiba.tuia.youtui.web.exception.ActivityRuntimeException;
import com.duiba.tuia.youtui.web.model.HttpRequest;
import com.duiba.tuia.youtui.web.service.InterfaceService;
import com.duiba.tuia.youtui.web.tool.DESUtil;
import com.duiba.tuia.youtui.web.tool.HttpRequestTool;
import com.duiba.tuia.youtui.web.tool.MD5;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import cn.com.duiba.tuia.activity.center.api.constant.EncryptType;
import cn.com.duiba.tuia.activity.center.api.constant.FieldNameSpace;
import cn.com.duiba.tuia.activity.center.api.constant.HttpMethod;
import cn.com.duiba.tuia.activity.center.api.constant.HttpProperty;
import cn.com.duiba.tuia.activity.center.api.constant.ParseType;
import cn.com.duiba.tuia.activity.center.api.constant.ProtocolType;
import cn.com.duiba.tuia.activity.center.api.dto.LandInterfaceLogDto;
import cn.com.duiba.tuia.activity.center.api.dto.inter.InterfaceHttpDto;
import cn.com.duiba.tuia.activity.center.api.dto.inter.InterfaceHttpEncryptDto;
import cn.com.duiba.tuia.activity.center.api.dto.inter.InterfaceHttpRequestDto;
import cn.com.duiba.tuia.activity.center.api.dto.inter.InterfaceHttpResponseDto;
import cn.com.duiba.tuia.activity.center.api.log.Log;
import cn.com.duiba.tuia.activity.center.api.remoteservice.RemoteLandService;

/**
 * ClassName: InterfaceServiceImpl <br/>
 * Function: 接口服务实现. <br/>
 * Reason: . <br/>
 * date: 2017年4月17日 下午8:21:39 <br/>
 *
 * @author wubo
 * @version
 * @since JDK 1.7
 */
@Service
public class InterfaceServiceImpl implements InterfaceService {
    /*
     * 设计思路
     * SDO(Service Data Object)
     * 写一个sdo 类,业务执行过程中,所有 参数放在 sdo中
     * 
     * 接受请求与remote调用支持http 和 dubbo
     * 
     * 实现过程：
     * 接收请求>入参set到sdo中> 循环执行:处理组件.run(sdo) > sdo中获取结果并返回
     * 
     * 
     * 处理组件
     * 接口：run(ServiceDataObject  sdo)
     * 实现类：加密组件，参数转化组件， 调用组件，json解析组件等，
     * 所有组件 从sdo获取参数，执行相关业务之后的结果put到sdo中。
     * 
     * 所有组件执行完成之后，从sdo中get(Response) 作为输出结果
     * 
     */

    protected Logger                             logger = LoggerFactory.getLogger(InterfaceServiceImpl.class);

    private static Map<String, InterfaceHttpDto> data   = Maps.newHashMap();
    
    private static final String RESPONSE = "i_response";

    @Resource
    private RemoteLandService                    remoteLandService;

    
    // 第三方接口配置，目前写死在代码，日后 功能化后做在数据库中
    static {
        //sms
        String interfaceCode = "sms";
        InterfaceHttpDto http = new InterfaceHttpDto("速易短信接口", interfaceCode, ProtocolType.HTTP,  "速易短信接口", true, "http://sx.360doo.com/api/smsHandler.ashx", HttpMethod.POST, ParseType.FORM,ParseType.JSON, false);

        List<InterfaceHttpRequestDto> request = Lists.newArrayList();
        List<InterfaceHttpResponseDto> response = Lists.newArrayList();
        List<InterfaceHttpEncryptDto> encrypt = Lists.newArrayList();
        // 参数配置
        request.add(new InterfaceHttpRequestDto(1L, interfaceCode, "phone", "phone", HttpProperty.BODY));
        request.add(new InterfaceHttpRequestDto(2L, interfaceCode, "c", "c", HttpProperty.URL));
        request.add(new InterfaceHttpRequestDto(3L, interfaceCode, "p", "p", HttpProperty.URL));
        request.add(new InterfaceHttpRequestDto(4L, interfaceCode, "v", "v", HttpProperty.URL));
        
        //加密参数配置
        encrypt.add(new InterfaceHttpEncryptDto(1L, EncryptType.CONSTENT, interfaceCode, "c", "4093", null));
        encrypt.add(new InterfaceHttpEncryptDto(2L, EncryptType.CONSTENT, interfaceCode, "p", "21179", null));
        encrypt.add(new InterfaceHttpEncryptDto(3L, EncryptType.MD5, interfaceCode, "v", "CSRW5X8Nd4f^48et", "2,3,1"));
               
        http.setRequest(request);
        http.setResponse(response);
        http.setEncrypt(encrypt);
        
        data.put(http.getInterfaceCode(), http);
    }
    
    static {
        //heiniu id=2
        String interfaceCode = "heiniu1";
        InterfaceHttpDto http = new InterfaceHttpDto("黑牛接口", interfaceCode, ProtocolType.HTTP,  "黑牛老接口,参考兑吧id=2", true, "http://www.muxiulin.com/api/insurance/duiba", HttpMethod.POST, ParseType.FORM,ParseType.JSON, false);

        List<InterfaceHttpRequestDto> request = Lists.newArrayList();
        List<InterfaceHttpResponseDto> response = Lists.newArrayList();
        List<InterfaceHttpEncryptDto> encrypt = Lists.newArrayList();
        
        request.add(new InterfaceHttpRequestDto(1L, interfaceCode, "userName", "name", HttpProperty.BODY));
        request.add(new InterfaceHttpRequestDto(2L, interfaceCode, "userPhone", "phone", HttpProperty.BODY));
        request.add(new InterfaceHttpRequestDto(3L, interfaceCode, "identification", "id_no", HttpProperty.BODY));
        request.add(new InterfaceHttpRequestDto(4L, interfaceCode, "sign", "sign", HttpProperty.BODY));
        request.add(new InterfaceHttpRequestDto(5L, interfaceCode, "resultPage", "result_page", HttpProperty.BODY));
        request.add(new InterfaceHttpRequestDto(6L, interfaceCode, "subchannel", "subchannel", HttpProperty.BODY));
        
        encrypt.add(new InterfaceHttpEncryptDto(1L, EncryptType.CONSTENT, interfaceCode, "resultPage", "1", null));
        encrypt.add(new InterfaceHttpEncryptDto(1L, EncryptType.MD5, interfaceCode, "sign", "baoxian-$@", "1,2,3"));
        encrypt.add(new InterfaceHttpEncryptDto(1L, EncryptType.SINGLE_DES, interfaceCode, "userName", "bx-15-@$", null));
        encrypt.add(new InterfaceHttpEncryptDto(1L, EncryptType.SINGLE_DES, interfaceCode, "userPhone", "bx-15-@$", null));
        encrypt.add(new InterfaceHttpEncryptDto(1L, EncryptType.SINGLE_DES, interfaceCode, "identification", "bx-15-@$", null));        
        
        http.setRequest(request);
        http.setResponse(response);
        http.setEncrypt(encrypt);
        
        data.put(http.getInterfaceCode(), http);
    }
    
    static {
        //heiniu id=3,5
        String interfaceCode = "heiniu2";
        InterfaceHttpDto http = new InterfaceHttpDto("黑牛接口", interfaceCode, ProtocolType.HTTP,  "黑牛老接口,参考兑吧id=3,5", true, "http://www.muxiulin.com/api/insurance/duiba", HttpMethod.POST, ParseType.FORM,ParseType.JSON, false);

        List<InterfaceHttpRequestDto> request = Lists.newArrayList();
        List<InterfaceHttpResponseDto> response = Lists.newArrayList();
        List<InterfaceHttpEncryptDto> encrypt = Lists.newArrayList();
        
        request.add(new InterfaceHttpRequestDto(1L, interfaceCode, "userName", "name", HttpProperty.BODY));
        request.add(new InterfaceHttpRequestDto(2L, interfaceCode, "userPhone", "phone", HttpProperty.BODY));
        request.add(new InterfaceHttpRequestDto(3L, interfaceCode, "identification", "id_no", HttpProperty.BODY));
        request.add(new InterfaceHttpRequestDto(4L, interfaceCode, "sign", "sign", HttpProperty.BODY));
        request.add(new InterfaceHttpRequestDto(5L, interfaceCode, "resultPage", "result_page", HttpProperty.BODY));
        request.add(new InterfaceHttpRequestDto(6L, interfaceCode, "subchannel", "subchannel", HttpProperty.BODY));
        
        encrypt.add(new InterfaceHttpEncryptDto(1L, EncryptType.CONSTENT, interfaceCode, "resultPage", "0", null));
        encrypt.add(new InterfaceHttpEncryptDto(1L, EncryptType.MD5, interfaceCode, "sign", "baoxian-$@", "1,2,3"));
        encrypt.add(new InterfaceHttpEncryptDto(1L, EncryptType.SINGLE_DES, interfaceCode, "userName", "bx-15-@$", null));
        encrypt.add(new InterfaceHttpEncryptDto(1L, EncryptType.SINGLE_DES, interfaceCode, "userPhone", "bx-15-@$", null));
        encrypt.add(new InterfaceHttpEncryptDto(1L, EncryptType.SINGLE_DES, interfaceCode, "identification", "bx-15-@$", null));        
        
        http.setRequest(request);
        http.setResponse(response);
        http.setEncrypt(encrypt);
        
        data.put(http.getInterfaceCode(), http);
    }

    static {
        //heiniu id=6
        String interfaceCode = "heiniu3";
        InterfaceHttpDto http = new InterfaceHttpDto("黑牛接口", interfaceCode, ProtocolType.HTTP,  "黑牛老接口,参考兑吧id=6", true, "http://www.muxiulin.com/api/insurance/duiba", HttpMethod.POST, ParseType.FORM,ParseType.JSON, false);

        List<InterfaceHttpRequestDto> request = Lists.newArrayList();
        List<InterfaceHttpResponseDto> response = Lists.newArrayList();
        List<InterfaceHttpEncryptDto> encrypt = Lists.newArrayList();
        
        request.add(new InterfaceHttpRequestDto(1L, interfaceCode, "userName", "name", HttpProperty.BODY));
        request.add(new InterfaceHttpRequestDto(2L, interfaceCode, "userPhone", "phone", HttpProperty.BODY));
        request.add(new InterfaceHttpRequestDto(3L, interfaceCode, "identification", "id_no", HttpProperty.BODY));
        request.add(new InterfaceHttpRequestDto(4L, interfaceCode, "sign", "sign", HttpProperty.BODY));
        request.add(new InterfaceHttpRequestDto(5L, interfaceCode, "resultPage", "result_page", HttpProperty.BODY));
        request.add(new InterfaceHttpRequestDto(6L, interfaceCode, "subchannel", "subchannel", HttpProperty.BODY));
        
        encrypt.add(new InterfaceHttpEncryptDto(1L, EncryptType.CONSTENT, interfaceCode, "resultPage", "2", null));
        encrypt.add(new InterfaceHttpEncryptDto(1L, EncryptType.MD5, interfaceCode, "sign", "baoxian-$@", "1,2,3"));
        encrypt.add(new InterfaceHttpEncryptDto(1L, EncryptType.SINGLE_DES, interfaceCode, "userName", "bx-15-@$", null));
        encrypt.add(new InterfaceHttpEncryptDto(1L, EncryptType.SINGLE_DES, interfaceCode, "userPhone", "bx-15-@$", null));
        encrypt.add(new InterfaceHttpEncryptDto(1L, EncryptType.SINGLE_DES, interfaceCode, "identification", "bx-15-@$", null));        
        
        http.setRequest(request);
        http.setResponse(response);
        http.setEncrypt(encrypt);
        
        data.put(http.getInterfaceCode(), http);
    }
    
    static {
        //newtank
        String interfaceCode = "newtank";
        InterfaceHttpDto http = new InterfaceHttpDto("新旦接口", interfaceCode, ProtocolType.HTTP,  "新旦接口", true, "http://www.newtank.cn/newtank/thp/insure.do", HttpMethod.POST, ParseType.JSON,ParseType.JSON, false);

        List<InterfaceHttpRequestDto> request = Lists.newArrayList();
        List<InterfaceHttpResponseDto> response = Lists.newArrayList();
        List<InterfaceHttpEncryptDto> encrypt = Lists.newArrayList();
        
        request.add(new InterfaceHttpRequestDto(1L, interfaceCode, "userName", "name", HttpProperty.BODY));
        request.add(new InterfaceHttpRequestDto(2L, interfaceCode, "userPhone", "mobile", HttpProperty.BODY));
        request.add(new InterfaceHttpRequestDto(3L, interfaceCode, "identification", "idCard", HttpProperty.BODY));
        request.add(new InterfaceHttpRequestDto(4L, interfaceCode, "sign", "sign", HttpProperty.BODY));
        request.add(new InterfaceHttpRequestDto(5L, interfaceCode, "channelCode", "channelCode", HttpProperty.BODY));
        request.add(new InterfaceHttpRequestDto(6L, interfaceCode, "productCode", "productCode", HttpProperty.BODY));
        request.add(new InterfaceHttpRequestDto(7L, interfaceCode, "effectiveTimes", "effectiveTimes", HttpProperty.BODY));
        request.add(new InterfaceHttpRequestDto(8L, interfaceCode, "key", "key", HttpProperty.HIDE));//此参数不传给 目标系统
        request.add(new InterfaceHttpRequestDto(9L, interfaceCode, "Content-Type", "Content-Type", HttpProperty.HEAD));
        
        encrypt.add(new InterfaceHttpEncryptDto(1L, EncryptType.CONSTENT, interfaceCode, "channelCode", "duiba", null));
        encrypt.add(new InterfaceHttpEncryptDto(1L, EncryptType.CONSTENT, interfaceCode, "productCode", "duiba_virtual", null));
        encrypt.add(new InterfaceHttpEncryptDto(1L, EncryptType.CONSTENT, interfaceCode, "key", "44add932a2898c91e40455d866279705", null));
        encrypt.add(new InterfaceHttpEncryptDto(1L, EncryptType.CONSTENT, interfaceCode, "Content-Type", "application/json", null));
        encrypt.add(new InterfaceHttpEncryptDto(1L, EncryptType.MD5, interfaceCode, "sign", "", "5,8,2"));
        
        http.setRequest(request);
        http.setResponse(response);
        http.setEncrypt(encrypt);
        
        data.put(http.getInterfaceCode(), http);
    }

    static {
        //newtank 更新接口
        String interfaceCode = "newtankUpdate";
        InterfaceHttpDto http = new InterfaceHttpDto("新旦更新接口", interfaceCode, ProtocolType.HTTP,  "新旦更新用户问券信息接口", true, "http://www.newtank.cn/newtank/thp/extrainfo", HttpMethod.POST, ParseType.JSON,ParseType.JSON, false);

        List<InterfaceHttpRequestDto> request = Lists.newArrayList();
        List<InterfaceHttpResponseDto> response = Lists.newArrayList();
        List<InterfaceHttpEncryptDto> encrypt = Lists.newArrayList();
        
        request.add(new InterfaceHttpRequestDto(1L, interfaceCode, "uid", "uid", HttpProperty.BODY));
        request.add(new InterfaceHttpRequestDto(2L, interfaceCode, "type", "type", HttpProperty.BODY));
        request.add(new InterfaceHttpRequestDto(5L, interfaceCode, "channelCode", "channelCode", HttpProperty.BODY));
        request.add(new InterfaceHttpRequestDto(6L, interfaceCode, "questionnaire", "questionnaire", HttpProperty.BODY));
        request.add(new InterfaceHttpRequestDto(9L, interfaceCode, "Content-Type", "Content-Type", HttpProperty.HEAD));
        
        encrypt.add(new InterfaceHttpEncryptDto(1L, EncryptType.CONSTENT, interfaceCode, "channelCode", "duiba", null));
//        encrypt.add(new InterfaceHttpEncryptDto(1L, EncryptType.CONSTENT, interfaceCode, "type", "2", null));
        encrypt.add(new InterfaceHttpEncryptDto(1L, EncryptType.CONSTENT, interfaceCode, "Content-Type", "application/json", null));
        
        http.setRequest(request);
        http.setResponse(response);
        http.setEncrypt(encrypt);
        
        data.put(http.getInterfaceCode(), http);
    }
    
    @Override
    public String invoke(String interfaceCode, Map<String, Object> params) {
        InterfaceHttpDto httpConfig = this.selectByInterfaceCode(interfaceCode);
        
        if(httpConfig!=null){
            
            JSONObject sdo = new JSONObject(params);
            if(ProtocolType.HTTP == httpConfig.getProtocolType()){
                invokeHttp(httpConfig,sdo);
            }
            return sdo.getString(RESPONSE);
        }else{
            throw new ActivityRuntimeException("服务不存在,interfaceCode=" + interfaceCode);
        }     
        
    }
    public InterfaceHttpDto selectByInterfaceCode(String interfaceCode) {
        return data.get(interfaceCode);
    }

    /*
     * http接口调用
     */
    public void invokeHttp(InterfaceHttpDto httpConfig, JSONObject sdo) {

        HttpRequest request = new HttpRequest();
        request.setRequestType(httpConfig.getRequestType());
        configEncryptSdo(httpConfig, sdo, request); // 加密入参配置
        configParam(httpConfig, sdo, request); // 入参配置
        invoke(httpConfig, request); // 调用
        parseResponse(httpConfig, sdo, request);  //解析返回结果
//        insertLog(httpConfig, sdo, request); // 日志
        
    }

    private void insertLog(InterfaceHttpDto httpConfig, JSONObject sdo, HttpRequest request) {
        if (Boolean.TRUE == httpConfig.getIsLog()) {
            try {
                LandInterfaceLogDto dto = new LandInterfaceLogDto();

                // channel
                dto.setChannel(sdo.getString(FieldNameSpace.CHANNEL));
                // landId
                dto.setLandId(sdo.getLong(FieldNameSpace.LAND_ID));
                dto.setUserId(sdo.getLong("uid"));
                dto.setUrl(request.getUrl());
                dto.setRequestBody(request.getRequest());
                dto.setResponseBody(request.getResponse());

                this.remoteLandService.insertLandInterfaceLog(dto);
            } catch (Exception e) {
                logger.error("land log insert error", e);
            }
        }
    }

    /*
     * 调接口
     */
    private void invoke(InterfaceHttpDto httpConfig, HttpRequest request) {
        request.setUrl(httpConfig.getUrl());
        request.setMethod(httpConfig.getMethodType().getCode());
        HttpRequestTool.request(request);
    }

    /*
     * 参数
     */
    private void configParam(InterfaceHttpDto httpConfig, JSONObject sdo, HttpRequest request) {
        
        List<InterfaceHttpRequestDto> params = httpConfig.getRequest();
        for (InterfaceHttpRequestDto param : params) {
            if (param.getPropertyType() == HttpProperty.URL) {
                request.putUrlParameter(param.getRemoteName(), sdo.getString(param.getOwnName()));
            } else if (param.getPropertyType() == HttpProperty.BODY) {
                request.putBodyParameter(param.getRemoteName(), sdo.getString(param.getOwnName()));
            } else if (param.getPropertyType() == HttpProperty.HEAD) {
                request.putHeadParameter(param.getRemoteName(), sdo.getString(param.getOwnName()));
            }

        }
    }

    /*
     * 加密sdo 设置
     */
    private void configEncryptSdo(InterfaceHttpDto httpConfig, JSONObject sdo, HttpRequest request) {
        List<InterfaceHttpEncryptDto> encrypts = httpConfig.getEncrypt();
        if (CollectionUtils.isNotEmpty(encrypts)) {
            for (InterfaceHttpEncryptDto encrypt : encrypts) {
                if (EncryptType.MD5 == encrypt.getType()) {
                    md5Encrypt(encrypt, httpConfig, sdo);
                } else if (EncryptType.CONSTENT == encrypt.getType()) {
                    constantEncrypt(encrypt, httpConfig, sdo);
                } else if (EncryptType.SINGLE_DES == encrypt.getType()) {
                    singleDESEncrypt(encrypt, httpConfig, sdo);
                } else {
                    throw new ActivityRuntimeException("dot't support this encrypt type");
                }
            }
        }

    }

    /*
     * Md5加密 MD5(参数1+参数2...+key)
     */
    private void md5Encrypt(InterfaceHttpEncryptDto encrypt, InterfaceHttpDto httpConfig, JSONObject sdo) {
        List<InterfaceHttpRequestDto> requests = findRequestDto(encrypt,httpConfig);
        StringBuilder encryptStr = new StringBuilder();
        for (InterfaceHttpRequestDto r : requests) {
            encryptStr.append(sdo.get(r.getOwnName()));
        }
        encryptStr.append(encrypt.getEncryptKey());
        try {
            String value = MD5.md5(encryptStr.toString());
            sdo.put(encrypt.getEncryptName(), value);
        } catch (NoSuchAlgorithmException | UnsupportedEncodingException e) {
            logger.error("md5 error", e);
        }

    }

    /*
     * 一些固定参数
     */
    private void constantEncrypt(InterfaceHttpEncryptDto encrypt, InterfaceHttpDto httpConfig, JSONObject sdo) {
        String value = encrypt.getEncryptKey();
        sdo.put(encrypt.getEncryptName(), value);
    }
    
    /*
     * DES 加密(单个参数)
     */
    private void singleDESEncrypt(InterfaceHttpEncryptDto encrypt, InterfaceHttpDto httpConfig, JSONObject sdo){
        String name = encrypt.getEncryptName(); //加密参数name
        String value = sdo.getString(name);     //加密参数值
        String key = encrypt.getEncryptKey();   //加密的key
        String rs = DESUtil.encryt(value, key);
        sdo.put(name, rs);
    }
    
    
    private List<InterfaceHttpRequestDto> findRequestDto(InterfaceHttpEncryptDto encrypt, InterfaceHttpDto httpConfig){
        String reqIds = encrypt.getReqIds();
        List<InterfaceHttpRequestDto> requests = null;
        if (StringUtils.isNotBlank(reqIds)) {
            List<Long> ids = transToList(reqIds);
            requests = findRequestByIds(httpConfig, ids);
        }
        return requests;
    }
    

    /*
     * put加密参数
     */
//    private void putEncryParam(InterfaceHttpEncryptDto encrypt, HttpRequest request, String value) {
//        if (HttpProperty.URL == encrypt.getPropertyType()) {
//            request.putUrlParameter(encrypt.getEncryptName(), value);
//        } else if (HttpProperty.BODY == encrypt.getPropertyType()) {
//            request.putBodyParameter(encrypt.getEncryptName(), value);
//        } else {
//            throw new ActivityRuntimeException("dot't support this property type");
//        }
//    }

    private List<Long> transToList(String idStr) {
        List<Long> ids = Lists.newArrayList();
        if (StringUtils.isNotBlank(idStr)) {
            String[] idStrs = idStr.split(",");
            for (String id : idStrs) {
                ids.add(Long.parseLong(id));
            }
        }
        return ids;
    }

    /*
     * 此方法要保证结果顺序跟ids一致
     */
    private List<InterfaceHttpRequestDto> findRequestByIds(final InterfaceHttpDto httpConfig, List<Long> ids) {
        List<InterfaceHttpRequestDto> rs = Lists.newArrayList();
        for (Long id : ids) {
            InterfaceHttpRequestDto dto = httpConfig.getRequestById(id);
            if (dto != null) {
                rs.add(dto);
            }
        }
        return rs;
    }

    /*
     * 解析结果
     * 暂时只支持解析json格式(当前方法暂不可用)
     */
    private void parseResponse(InterfaceHttpDto httpConfig, JSONObject sdo, HttpRequest request) {
        String response;
        if (Boolean.TRUE == httpConfig.getIsTranslate()) {
            if(ParseType.JSON == httpConfig.getResponseType()){
                response = parseJson(httpConfig,request);
            }else{
                throw new ActivityRuntimeException("can't support this parse type");
            }
            
        }else{
            response = request.getResponse();
        }
        
        sdo.put(RESPONSE, response);
    }
    
    /*
     * 这代码不太好用
     */
    private String parseJson(InterfaceHttpDto httpConfig,HttpRequest request){
        String response;
        List<InterfaceHttpResponseDto> resps = httpConfig.getResponse();
        
        JSONObject source = JSONObject.parseObject(request.getResponse());//考虑 是否需要 自己写个JSONObject,方便解析用
        Log target = null;//需要的功能这个类都有，临时用下
        for(InterfaceHttpResponseDto resp : resps){
            String remotePath = resp.getRemotePath();
            String[] paths = remotePath.split("/");
            String ownPath = resp.getOwnPath();
            String[] ownPaths = ownPath.split("/");
            
            String rs;
            if(paths!=null&&paths.length>0){
                int last = paths.length -1;
                
                JSONObject temp = source;
                JSONObject child;
                
                for(int i = 0;i<last;i++){
                    child = temp.getJSONObject(paths[i]);
                    temp = child;
                }
                rs = temp.getString(paths[last]);
            }else{
                continue;
            }

            target = getLog(target, ownPaths, rs);

        }
        if(target != null){
            response = target.toJSONString();
        }else{
            response = null;
        }
        
        return response;
    }

    private Log getLog(Log target, String[] ownPaths, String rs) {
        if(ownPaths!=null&&ownPaths.length>0){

            int last = ownPaths.length-1;
            target = new Log();
            Log temp = target;
            Log child;
            for(int i=0;i<last-1;i++){
                child = new Log();
                temp.setChild(ownPaths[i], child); //设置子结点
                temp = child;                      //在子节点中接续设置子节点
            }
            temp.put(ownPaths[last], rs);
        }
        return target;
    }


}
