/**
 * Project Name:tuia-youtui-web<br>
 * File Name:ActivityOrderServiceImpl.java<br>
 * Package Name:com.duiba.tuia.youtui.web.service.impl<br>
 * Date:2017年2月4日下午5:02:24<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */

package com.duiba.tuia.youtui.web.service.impl;


import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.constant.AlipayOrderStatus;
import cn.com.duiba.tuia.activity.center.api.constant.AlipayType;
import cn.com.duiba.tuia.activity.center.api.constant.VirtualRechargeType;
import cn.com.duiba.tuia.activity.center.api.dto.*;
import cn.com.duiba.tuia.activity.center.api.dto.req.ReqAliOrderQuery;
import cn.com.duiba.tuia.activity.center.api.dto.req.ReqVirtualRecharge;
import cn.com.duiba.tuia.activity.center.api.dto.req.VirtualContext;
import cn.com.duiba.tuia.activity.center.api.remoteservice.RemoteActivityOrderService;
import cn.com.duiba.tuia.activity.center.api.remoteservice.RemoteActivityService;
import cn.com.duiba.tuia.activity.center.api.remoteservice.RemoteAlipayService;
import cn.com.duiba.tuia.activity.center.api.remoteservice.RemoteVirtualService;
import cn.com.duiba.tuia.ssp.center.api.dto.MediaAppDataDto;
import cn.com.duiba.tuia.ssp.center.api.dto.MediaAppDto;
import cn.com.duiba.tuia.ssp.center.api.dto.SlotDto;
import cn.com.duiba.tuia.ssp.center.api.remote.RemoteMediaAppService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONObject;
import com.dianping.cat.Cat;
import com.duiba.tuia.youtui.web.constant.Constants;
import com.duiba.tuia.youtui.web.constant.ErrorCode;
import com.duiba.tuia.youtui.web.constant.TempFunction;
import com.duiba.tuia.youtui.web.exception.ActivityException;
import com.duiba.tuia.youtui.web.model.req.*;
import com.duiba.tuia.youtui.web.service.*;
import com.duiba.tuia.youtui.web.tool.DomainConstantUtil;
import com.duiba.tuia.youtui.web.tool.RequestLocal;
import com.duiba.tuia.youtui.web.tool.StyleTypeUtil;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;


/**
 * ClassName: ActivityOrderServiceImpl <br/>
 * Function: 活动订单实现类. <br/>
 * date: 2017年2月4日 下午5:02:24 <br/>
 *
 * @author leiliang
 * @since JDK 1.6
 */
@Service
public class ActivityOrderServiceImpl extends BaseService implements ActivityOrderService {

    @Autowired
    private RemoteActivityOrderService remoteActivityOrderService;

    @Autowired
    private RemoteAlipayService remoteAlipayService;

    @Autowired
    private RemoteMediaAppService remoteMediaAppService;

    @Autowired
    private RemoteVirtualService remoteVirtualService;

    @Autowired
    private RemoteActivityService remoteActivityService;

    @Autowired
    private AppService appService;

    @Autowired
    private PrizeService prizeService;

    @Autowired
    private ActivityService activityService;

    @Override
    public RspOrder createOrder(DoJoinActivityReq doJoinActivityReq, TuiaActivityDto activityDto)
            throws ActivityException {
        ActivityOrderDto activityOrderDto = new ActivityOrderDto();
        activityOrderDto.setAppId(doJoinActivityReq.getAppId());
        activityOrderDto.setActivityId(doJoinActivityReq.getActivityId());
        activityOrderDto.setActivityType(doJoinActivityReq.getActivityType());
        activityOrderDto.setConsumerId(doJoinActivityReq.getConsumerId());
        activityOrderDto.setIp(doJoinActivityReq.getIp());
        activityOrderDto.setSourceOrderId(doJoinActivityReq.getAgainOrderId());

        DubboResult<RspOrder> orderIdResult = remoteActivityOrderService.insert(activityOrderDto);
        if (!orderIdResult.isSuccess() || orderIdResult.getResult() == null) {
            logger.warn("[Tuia-Activity]create order happen error, the req=[{}] , and because of=[{}]",
                    activityOrderDto, orderIdResult.getMsg());
            throw new ActivityException(ErrorCode.E0120002.geteCode(), ErrorCode.E0120002.geteDesc());
        }
        try {
            Cat.logMetricForCount("活动中心-活动参与");
        } catch (Exception e) {
            logger.error(Constants.CAT_ERROR, e);
        }

        return orderIdResult.getResult();
    }

    @Override
    public RspOrder createOrderForDirectPage(DoJoinActivityReq doJoinActivityReq) throws ActivityException {
        ActivityOrderDto activityOrderDto = new ActivityOrderDto();
        activityOrderDto.setAppId(doJoinActivityReq.getAppId());
        activityOrderDto.setConsumerId(doJoinActivityReq.getConsumerId());
        activityOrderDto.setIp(doJoinActivityReq.getIp());
        activityOrderDto.setActivityId(0L);

        activityOrderDto.setCouponData(doJoinActivityReq.getParamMap());

        DubboResult<RspOrder> orderIdResult = remoteActivityOrderService.insert(activityOrderDto);
        if (!orderIdResult.isSuccess() || orderIdResult.getResult() == null) {
            logger.warn("[Tuia-Activity]create order happen error, the req=[{}] , and because of=[{}]",
                    activityOrderDto, orderIdResult.getMsg());
            throw new ActivityException(ErrorCode.E0400006);
        }
        try {
            Cat.logMetricForCount("活动中心-直投广告投放");
        } catch (Exception e) {
            logger.error(Constants.CAT_ERROR, e);
        }
        return orderIdResult.getResult();
    }

    @Override
    public void updateOrderOfOptionThanks(String orderId, Long consumerId, OptionDto option)
            throws ActivityException {
        updateActivityDto(orderId, consumerId, option);
    }


    @Override
    public Integer createPhysicalOrder(String orderId, OptionDto option, DoJoinActivityReq doJoinActivityReq, PrizeDto prizeDto) {
        AlipayOrderDto dto = new AlipayOrderDto();
        dto.setOrderId(orderId);
        dto.setActivityType(option.getActivityType());
        dto.setPrizeId(option.getId());
        dto.setPrizeTitle(option.getTitle());
        dto.setAlipayType(AlipayType.PHYSICAL.getType());
        dto.setStatus(AlipayOrderStatus.DEALING.getStatus());
        dto.setActivityId(option.getActivityId());
        dto.setAppId(doJoinActivityReq.getAppId());
        dto.setDeviceId(doJoinActivityReq.getDeviceId());
        dto.setSlotId(doJoinActivityReq.getSlotId());
        dto.setAwardAmount(prizeDto.getPrizeValue());
        DubboResult<Integer> result = remoteAlipayService.insertAlipayOrder(dto);
        return result.getResult();
    }

    @Override
    public void updateActivityOrderOfPrize(String orderId, Long consumerId, OptionDto option, PrizeDto prizeDto)
            throws ActivityException {
        ActivityOrderDto dto = new ActivityOrderDto();
        dto.setOrderId(orderId);
        dto.setConsumerId(consumerId);
        dto.setPrizeType(option.getPrizeType());
        dto.setPrizeId(option.getId());
        dto.setGid(option.getPrizeId());//把奖品ID放置在Gid字段中，没有Gtype，因为不是商品中心类型
        Map<String, String> extInfo = new HashMap<>(4);
        extInfo.put(ActivityOrderDto.PrizeInfo.TITLE, option.getTitle());
        extInfo.put(ActivityOrderDto.PrizeInfo.BANNER_IMAGE, prizeDto.getBannerImage());
        extInfo.put(ActivityOrderDto.PrizeInfo.DETAIL_IMAGE, prizeDto.getDetailImage());
        extInfo.put(ActivityOrderDto.PrizeInfo.LIST_IMAGE, prizeDto.getListImage());
        dto.setCouponData(extInfo);
        DubboResult<Long> updateResult = remoteActivityOrderService.updateByOrderId(dto);
        if (!updateResult.isSuccess()) {
            logger.warn("[TUIA-ACTIVITY] remoteActivityOrderService.update failed, the req=[{}], and because of=[{}]",
                    dto, updateResult.getMsg());
            throw new ActivityException(ErrorCode.E0400007);
        }
    }

    @Override
    public Integer createAlipayOrder(String orderId, OptionDto option, int amount, DoJoinActivityReq doJoinActivityReq) {
        AlipayOrderDto dto = new AlipayOrderDto();
        dto.setOrderId(orderId);
        dto.setActivityType(option.getActivityType());
        dto.setAwardAmount(amount);
        dto.setPrizeId(option.getId());
        dto.setPrizeTitle(option.getTitle());
        dto.setAlipayType(option.getAlipayType());
        dto.setStatus(AlipayOrderStatus.DEALING.getStatus());
        dto.setActivityId(option.getActivityId());
        dto.setAppId(doJoinActivityReq.getAppId());
        dto.setDeviceId(doJoinActivityReq.getDeviceId());
        dto.setSlotId(doJoinActivityReq.getSlotId());
        DubboResult<Integer> result = remoteAlipayService.insertAlipayOrder(dto);
        return result.getResult();
    }

    @Override
    public Integer createQBOrder(String orderId, OptionDto option, int amount, DoJoinActivityReq doJoinActivityReq,PrizeDto prizeDto) {
        return createAlipayOrder(orderId, option, amount*prizeDto.getPrizeValue(), doJoinActivityReq);
    }

    @Override
    public Integer createBillOrder(String orderId, OptionDto option, int amount, DoJoinActivityReq doJoinActivityReq) {
        return createAlipayOrder(orderId, option, amount, doJoinActivityReq);
    }

    @Override
    public Integer updateAlipayOrder(AlipayOrderDto dto) {
        DubboResult<Integer> result = remoteAlipayService.updateAlipayOrderByOrderId(dto);
        return result.getResult();
    }

    @Override
    public Integer createVirtualTicketOrder(String orderId, OptionDto option, DoJoinActivityReq doJoinActivityReq,CouponsCodeDto coupon) {
        coupon.setUseInfo(null);//不需要的字段不存，防止撑爆订单表ext 字段
        AlipayOrderDto dto = this.createOrder(orderId, option, doJoinActivityReq);
        dto.setStatus(AlipayOrderStatus.SUCCESS.getStatus());
        dto.setCoupon(coupon);
        return insertPrizeOrder(dto);
    }

    @Override
    public Integer createVirtualApiOrder(String orderId, OptionDto option, DoJoinActivityReq doJoinActivityReq,PrizeDto prizeDto,Integer amount,String amountStr) {
        AlipayOrderDto dto = this.createOrder(orderId, option, doJoinActivityReq);
        List<AccountRechargeDto> list = prizeDto.getAccountRechargeDto();
        List<VirtualContext> vcs = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(account->{
                VirtualContext virtualContext = new VirtualContext();
                virtualContext.setKey(account.getContext());
                virtualContext.setType(account.getType());
                vcs.add(virtualContext);
            });
        }
        dto.setContextArray(vcs);
        dto.setAwardAmount(amount);
        dto.setPrizeWorth(amountStr);

        return insertPrizeOrder(dto);
    }

    @Override
    public Integer createRedPacketOrder(String orderId, OptionDto option, DoJoinActivityReq doJoinActivityReq) {
        AlipayOrderDto dto = this.createOrder(orderId, option, doJoinActivityReq);
        dto.setStatus(AlipayOrderStatus.SUCCESS.getStatus());
        return insertPrizeOrder(dto);
    }


    public Integer insertPrizeOrder(AlipayOrderDto dto) {
        return remoteAlipayService.insertAlipayOrder(dto).getResult();
    }

    public AlipayOrderDto createOrder(String orderId, OptionDto option,DoJoinActivityReq doJoinActivityReq) {
        AlipayOrderDto dto = new AlipayOrderDto();
        dto.setOrderId(orderId);
        dto.setActivityType(option.getActivityType());
        dto.setPrizeId(option.getId());
        dto.setPrizeTitle(option.getTitle());
        dto.setAlipayType(option.getAlipayType());
        dto.setStatus(AlipayOrderStatus.DEALING.getStatus());
        dto.setActivityId(option.getActivityId());
        dto.setAppId(doJoinActivityReq.getAppId());
        dto.setDeviceId(doJoinActivityReq.getDeviceId());
        dto.setSlotId(doJoinActivityReq.getSlotId());
        return dto;
    }

    @Override
    public AlipayOrderDto selectAlipayOrder(String orderId) {
        DubboResult<AlipayOrderDto> result = remoteAlipayService.selectAlipayOrderByOrderId(orderId);
        return result.getResult();
    }

    @Override
    public void updateOrder(String orderId, Long consumerId, OptionDto option, String couponData)
            throws ActivityException {
        updateActivityOrderCouponData(orderId, consumerId, option, couponData);
    }

    private void updateActivityOrderCouponData(String orderId, Long consumerId, OptionDto option, String couponData) throws ActivityException {
        ActivityOrderDto dto = new ActivityOrderDto();
        dto.setOrderId(orderId);
        dto.setConsumerId(consumerId);
        dto.setAdvertId(option.getAdvertId());
        dto.setGid(option.getGid());
        dto.setGtype(option.getGtype());
        dto.setPrizeId(option.getId());
        dto.setPrizeType(option.getPrizeType());
        dto.setCouponData(couponData);
        DubboResult<Long> updateResult = remoteActivityOrderService.updateByOrderId(dto);
        if (!updateResult.isSuccess()) {
            logger.warn("[TUIA-ACTIVITY] remoteActivityOrderService.update failed, the req=[{}], and because of=[{}]",
                    dto, updateResult.getMsg());
            throw new ActivityException(ErrorCode.E0400007);
        }
    }


    @Override
    public RspOrder createPluginToolsOrder(DoJoinActivityReq doJoinPluginToolsReq)
            throws ActivityException {
        ActivityOrderDto activityOrderDto = new ActivityOrderDto();
        activityOrderDto.setAppId(doJoinPluginToolsReq.getAppId());
        activityOrderDto.setActivityId(doJoinPluginToolsReq.getActivityId());
        activityOrderDto.setActivityType(doJoinPluginToolsReq.getActivityType());
        activityOrderDto.setConsumerId(doJoinPluginToolsReq.getConsumerId());
        activityOrderDto.setIp(doJoinPluginToolsReq.getIp());
        activityOrderDto.setSourceOrderId(0L);

        DubboResult<RspOrder> orderIdResult = remoteActivityOrderService.insert(activityOrderDto);
        if (!orderIdResult.isSuccess() || orderIdResult.getResult() == null) {
            logger.warn("[Tuia-Activity]create order happen error, the req=[{}] , and because of=[{}]",
                    activityOrderDto, orderIdResult.getMsg());
            throw new ActivityException(ErrorCode.E0400006);
        }
        try {
            //1.cat记录插件工具参与次数
            Cat.logMetricForCount("活动中心-插件参与");
        } catch (Exception e) {
            logger.error(Constants.CAT_ERROR, e);
        }

        return orderIdResult.getResult();
    }


    @Override
    public void updatePluginToolsOrder(String orderId, Long consumerId, OptionDto option, String couponData)
            throws ActivityException {
        updateActivityOrderCouponData(orderId, consumerId, option, couponData);
    }

    @Override
    public ActivityOrderDto selectByIdAndConsumerId(String orderId, Long consumerId) throws ActivityException {
        DubboResult<ActivityOrderDto> orderResult = remoteActivityOrderService.selectByOrderIdAndConsumerId(orderId,
                consumerId);
        if (!orderResult.isSuccess()) {
            logger.warn("[TUIA-ACTIVITY] remoteActivityOrderService.selectByIdAndConsumerId failed, the orderId=[{}], the consumerId =[{}], and because of=[{}]",
                    orderId, consumerId, orderResult.getMsg());
            throw new ActivityException(ErrorCode.E0400008);
        }

        if (orderResult.getResult() == null) {
            logger.info("the orderId=[{}] non-existent, the consumerId =[{}], and because of=[{}]", orderId, consumerId);
            throw new ActivityException(ErrorCode.E0400009);
        }
        return orderResult.getResult();
    }

    @Override
    public boolean isShowBuoy(TuiaActivityDto activityDto, SlotDto slotDto, Long consumerId, int joinTimes, long styleType) {
        if (!TempFunction.displayBuoy(activityDto.getId())) {
            return false;
        }

        // 广告位配置是否开启浮标
        if (slotDto.getPlugBuoyConfigDto() == null || slotDto.getPlugBuoyConfigDto().getBuoyStatus() == null || slotDto.getPlugBuoyConfigDto().getBuoyStatus() == 1) {
            return false;
        }

        if (TempFunction.isTmpDemandSlot(slotDto.getId())) {
            if (joinTimes - StyleTypeUtil.quarter(styleType) >= 0) {
                return true;
            } else {
                return false;
            }
        }

        // 活动参与几次后触发插件
        // 活动与广告位均可配置参与次数，以活动参与次数优先
        Integer num = slotDto.getPlugBuoyConfigDto().getBuoyCount();

        if (num == null) {
            return false;
        }

        // 当用户在该活动参与次数达到设置的浮标展示频次时，此时及后续页面均需展示浮标
        return joinTimes >= num;

    }

    @Override
    public void updatePluginToolsOrderThanks(String orderId, Long consumerId, OptionDto option)
            throws ActivityException {

        updateActivityDto(orderId, consumerId, option);

    }

    private void updateActivityDto(String orderId, Long consumerId, OptionDto option) throws ActivityException {
        ActivityOrderDto dto = new ActivityOrderDto();
        dto.setOrderId(orderId);
        dto.setConsumerId(consumerId);
        dto.setPrizeType(option.getPrizeType());
        dto.setPrizeId(option.getId());
        DubboResult<Long> updateResult = remoteActivityOrderService.updateByOrderId(dto);
        if (!updateResult.isSuccess()) {
            logger.warn("[TUIA-ACTIVITY] remoteActivityOrderService.update failed, the req=[{}], and because of=[{}]",
                    dto, updateResult.getMsg());
            throw new ActivityException(ErrorCode.E0400007);
        }
    }

    @Override
    public AlipayRsp transferToAccount(AlipayReq req) {
        AlipayParam param = new AlipayParam();
        Optional<MediaAppDto> mediaApp = appService.getMediaApp(RequestLocal.get().getAppId());
        DubboResult<AlipayOrderDto> orderResult = remoteAlipayService.selectAlipayOrderByOrderId(req.getOrderId());
        param.setParam(AlipayParam.OUT_BIZ_NO, req.getOrderId());
        param.setParam(AlipayParam.PAYEE_ACCOUNT, req.getAccount().trim());
        param.setParam(AlipayParam.PAYEE_REAL_NAME, req.getName().trim());
        param.setParam(AlipayParam.AMOUNT, orderResult.getResult().getAwardAmount().toString());
        if (!mediaApp.isPresent()) {
            param.setParam(AlipayParam.PAYER_SHOW_NAME, "推啊科技");//打波广告
        } else {
            param.setParam(AlipayParam.PAYER_SHOW_NAME, mediaApp.get().getAppName());
        }
        DubboResult<AlipayRsp> result = remoteAlipayService.toAccountTransfer(param);
        return result.getResult();
    }

    @Override
    public List<AlipayOrderDto> selectAlipayRecord(String deviceId) {
        DubboResult<List<AlipayOrderDto>> listDubboResult = remoteAlipayService.selectAlipayOrderByDeviceId(null, deviceId, null, null);
        return listDubboResult.getResult();
    }

    @Override
    public Boolean submitPhysicalInfo(PhysicalReq req) {
        AlipayOrderDto orderDto = new AlipayOrderDto();
        orderDto.setOrderId(req.getOrderId());
        orderDto.setAliName(req.getConsignee());
        orderDto.setAliAccount(req.getPhoneNumber());
        orderDto.setShippingAddress(req.getShippingAddress());
        orderDto.setStatus(AlipayOrderStatus.NEED_SEND.getStatus());
        DubboResult<Integer> result = remoteAlipayService.updateAlipayOrderByOrderId(orderDto);
        return Integer.valueOf(1).equals(result.getResult());
    }

    @Override
    public List<AlipayOrderDto> selectAlipayRecords(ReqAliOrderQuery reqPageQuery) {
        DubboResult<PageDto<AlipayOrderDto>> pageDtoDubboResult = remoteAlipayService.selectAlipayOrderPage(reqPageQuery);
        if (!pageDtoDubboResult.isSuccess() || pageDtoDubboResult.getResult() == null) {
            return Collections.emptyList();
        }
        return pageDtoDubboResult.getResult().getList();
    }

    @Override
    public Boolean submitVirtualPrizeInfo(VirtualWinnerReq virtualWinnerReq) throws ActivityException {
        AlipayOrderDto virtualOrder = selectAlipayOrder(virtualWinnerReq.getOrderId());
        if (null == virtualOrder) {
            logger.warn("无实物中奖记录信息。physicalOrder  is null ");
            throw new ActivityException(ErrorCode.E0200005);
        }
        //转义用户信息
        String infoReqs = "";
        if (StringUtils.isNotEmpty(virtualWinnerReq.getInfoReqs())) {
            infoReqs = StringEscapeUtils.unescapeHtml4(virtualWinnerReq.getInfoReqs());
        }
        if (AlipayType.VIRTUAL_ACCOUNT.getType().equals(virtualWinnerReq.getSubType())) {
            //账号收集
            AlipayOrderDto updateDto = new AlipayOrderDto();
            updateDto.setOrderId(virtualOrder.getOrderId());
            updateDto.setAlipayType(AlipayType.VIRTUAL_ACCOUNT.getType());
            updateDto.setStatus(AlipayOrderStatus.TRANSFER.getStatus());
            updateDto.setContextArray(JSONObject.parseArray(infoReqs, VirtualContext.class));
            updateAlipayOrder(updateDto);
        } else if (AlipayType.VIRTUAL_API.getType().equals(virtualWinnerReq.getSubType())) {
            //api充值
            return doApiRecharge(virtualWinnerReq, virtualOrder, infoReqs);
        }
        return true;
    }


    private Boolean doApiRecharge(VirtualWinnerReq virtualWinnerReq, AlipayOrderDto virtualOrder, String infoReqs) {
        String appKey = RequestLocal.get().getAppKey();//获取appKey
        String appSecret = "";//appsecret
        try {
            MediaAppDataDto mediaAppDataDto = appService.findAppByAppKey(appKey);
            appSecret = mediaAppDataDto.getAppSecret();
        } catch (Exception e) {
            return false;
        }
        ActivityOptionDto activityOptionDto = remoteActivityService.selectActivityOption(virtualOrder.getPrizeId()).getResult();

        //调用充值接口参数配置
        ReqVirtualRecharge reqVirtualRecharge = new ReqVirtualRecharge();
        reqVirtualRecharge.setOrderId(virtualWinnerReq.getOrderId());
        reqVirtualRecharge.setAppFlag(VirtualRechargeType.TUIA);
        reqVirtualRecharge.setVirtualAppId(virtualWinnerReq.getPrizeIdent());
        reqVirtualRecharge.setVirtualId(activityOptionDto.getPrizeId());
        reqVirtualRecharge.setUserId(getApiRechargeUserId(activityOptionDto.getPrizeId()));
        reqVirtualRecharge.setNumRecharge(virtualOrder.getPrizeWorth());
        reqVirtualRecharge.setContextArray(JSONObject.parseArray(infoReqs, VirtualContext.class));
        reqVirtualRecharge.setAppKey(appKey);
        reqVirtualRecharge.setAppSecret(appSecret);
        reqVirtualRecharge.setTitle(virtualOrder.getPrizeTitle());
        //API充值接口
        remoteVirtualService.recharge(reqVirtualRecharge);
        return true;
    }

    /**
     * 根据奖品配置url，选择用户名(区分媒体／现今钱包)
     *
     * @param prizeId
     * @return
     */
    private String getApiRechargeUserId(Long prizeId) {
        try {
            PrizeDto prizeDto = prizeService.selectPrizeById(prizeId);
            //内部用户
            if(prizeDto.getApiRechargeDto().getRechargeInfo().contains(DomainConstantUtil.getYoutuiDomain())) {
                return RequestLocal.get().getCid().toString();
            }
            //媒体用户
            return RequestLocal.get().getUserId();
        } catch (Exception e) {
            return RequestLocal.get().getUserId();
        }
    }

    @Override
    public RechargeQBRsp rechargeQB(RechargeQBReq req) {
        return remoteAlipayService.rechargeQB(req.getOrderId(),req.getAccount(),req.getAmount());
    }

    @Override
    public Long selectConsumerIdByOrderId(String orderId) throws ActivityException {
        return remoteActivityOrderService.selectConsumerIdByOrderId(orderId);
    }
}
