package com.duiba.tuia.youtui.web.service;

import cn.com.duiba.tuia.activity.center.api.constant.BalanceType;
import com.alibaba.fastjson.JSONObject;
import com.duiba.tuia.youtui.web.exception.ActivityException;
import com.duiba.tuia.youtui.web.model.req.AdvertEffectReq;
import com.duiba.tuia.youtui.web.model.req.TAdclickReq;
import com.duiba.tuia.youtui.web.model.req.TclickReq;
import com.duiba.tuia.youtui.web.model.req.TdislikeReq;
import com.duiba.tuia.youtui.web.model.toutiao.TouTiaoData;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

/**
 * ClassName: ThirPartyService <br/>
 * Function: 第三方接口服务. <br/>
 * date: 2017年08月16日  10:29:00 <br/>
 *
 * @author cdm
 * @version 1.0
 * @since JDK 1.8
 */
public interface ThirPartyService {

    /**
     *  获取头条信息
     * @param request
     * @return
     * @throws ActivityException
     */
    String getTdata(HttpServletRequest request,String category,String refreshTime) throws ActivityException;


    /**
     *  根据搜索获取头条信息
     * @param request
     * @return
     * @throws ActivityException
     */
    String  getTsearch(HttpServletRequest request,String keyword) throws ActivityException ;


    /**
     *  上报用户新闻点击事件
     * @param request
     * @return
     * @throws ActivityException
     */
    String getTclick(HttpServletRequest request, TclickReq req) throws ActivityException;



    /**
     *  上报用户广告点击事件
     * @param request
     * @return
     * @throws ActivityException
     */
    String getTAdclick(HttpServletRequest request, TAdclickReq req) throws ActivityException;


    /**
     *  上报用户不喜欢list事件
     * @param request
     * @return
     * @throws ActivityException
     */
    String getTdislike(HttpServletRequest request, TdislikeReq req) throws ActivityException;


    /**
     * 广告转化效果上报
     * @param request
     * @param advertEffectReq  广告转化传入对象
     * @return
     * @throws ActivityException
     */
    JSONObject advertEffect(HttpServletRequest request, AdvertEffectReq advertEffectReq) throws  ActivityException;

    /**
     * 获取头条信息(直投页中展示)
     * @param request
     * @return
     * @throws ActivityException
     */
    String getTNewdata(HttpServletRequest request,String category,String refreshTime) throws ActivityException;

    /**
     * 广告事件上报
     *
     * @param request
     * @param url
     * @param pageId
     * @param action
     * @return
     * @throws ActivityException
     */
    String getTNewAdReport(HttpServletRequest request, String url, Integer pageId, String action) throws ActivityException;

    Map<String,String> rechargeCash(Map<String, String> map, BalanceType balanceType);

    /**
     * 获取头条信息(直投页中展示,客户端上报)
     * @param request
     * @return
     * @throws ActivityException
     */
    TouTiaoData getTNewdata2(HttpServletRequest request, String category, String refreshTime) throws ActivityException;
}
