package com.duiba.tuia.youtui.web.service;

import cn.com.duiba.tuia.activity.center.api.dto.ButtonDto;
import cn.com.duiba.tuia.activity.center.api.dto.LayerSkinDto;
import com.duiba.tuia.youtui.web.model.req.SkinReq;

import java.util.List;
import java.util.concurrent.ExecutionException;

/**
 * Created by wubo on 2017/8/22.
 */
public interface SkinService {

    /**
     * 查询所有类型弹层皮肤
     *
     * 应用到内存缓存，如果需要修改内容，请克隆后修改，防止污染缓存
     * @return list
     * @throws ExecutionException
     */
    List<LayerSkinDto> selectAllLayerSkin(SkinReq req) throws ExecutionException;

    /**
     * 查询默认广告弹层皮肤id
     * @return
     */
    Long selectDefaultLayerId();

    /**
     * 查询随机支付宝弹层id
     * @return
     */
    Long selectAlipayRandomLayerId();

    /**
     * 查询定额支付宝弹层id
     * @return
     */
    Long selectAlipayQuotaLayerId();

    /**
     * 查询谢谢参与弹层ID
     * @return
     */
    Long selectThanksLayerId();

    /**
     * 查询qb弹层Id
     */
    Long selectQbQuotaLayerId();

    /**
     * 查询随机qb弹层id
     */
    Long selectQbRandomLayerId();

    /**
     * 查询话费 定额弹层id
     * @return
     */
    Long selectBillQuotaLayerId();

    /**
     * 查询话费 随机弹层id
     * @return
     */
    Long selectBillRandomLayerId();

    /**
     * 获取按钮样式
     *
     * @param id
     * @return
     */
    ButtonDto getButtonById(Long id) throws ExecutionException;

    /**
     * 根据弹层类型 查询弹层皮肤
     * @param type 弹层类型
     * @return
     */
    List<LayerSkinDto> selectLayerByTypeFromCache(Integer type);

    /**
     * 定制弹层
     * @param type
     * @return
     */
    LayerSkinDto selectSpecialLayer(Integer type);


}
