package com.duiba.tuia.youtui.web.service;

import cn.com.duiba.tuia.activity.center.api.dto.ActivityWinOrderDto;
import com.duiba.tuia.youtui.web.exception.ActivityException;
import com.duiba.tuia.youtui.web.model.Result;
import com.duiba.tuia.youtui.web.model.UserAccount;
import com.duiba.tuia.youtui.web.model.rsp.RedPacketInfoRsp;
import com.duiba.tuia.youtui.web.model.rsp.RedPacketsRsp;

import javax.servlet.http.HttpServletRequest;

/**
 * 瓜分红包的service 接口
 * @author lichao 2018/3/13
 */
public interface RedPacketService {

    /**
     * 获取红包
     *
     * @param consumer 用户
     * @param pageId   直投页id
     * @param host     host
     * @param dsm      dsm
     * @param activityId 活动id
     * @return 红包基本信息，红包数量
     */
    RedPacketInfoRsp getPacket(UserAccount consumer, Long pageId,
                               String host, String dsm, Long activityId) throws ActivityException;

    /**
     * 获取我的红包列表
     * @param consumer 用户
     * @param pageId 直投页id
     * @return 我的所有红包
     */
    RedPacketsRsp getPacketList(UserAccount consumer, Long pageId) throws ActivityException;

    /**
     * 获取我的红包列表
     * @param consumer 用户
     * @param pageId 直投页id
     * @return 我的余额
     */
    Long getAmount(UserAccount consumer, Long pageId);

    /**
     * 迁移旧账户至新账户
     * @param appId 媒体id
     * @param oldConsumerId
     * @param newConsumerId
     */
    void movePopus(Long appId, Long oldConsumerId, Long newConsumerId) throws ActivityException;

    /**
     * 中奖 获得红包
     * @param pageId 直投页id
     * @param orderId 订单id
     * @return 获取成功
     */
    boolean obtainPacket(Long appId, Long consumerId,Long pageId, String orderId);

     /** 提现
     * @param consumer 用户
     * @param alipayName 账户名称
     * @param alipayAccount 账户信息
     * @param amount 提现金额
     * @param pageId 直投页id
     * @return 订单
     */
    Result<ActivityWinOrderDto> cashWithdraw(UserAccount consumer, String alipayName, String alipayAccount, Long amount, Long pageId) throws ActivityException;

    /**
     * 通过活动位获取直投页url
     * @param slotId 广告位id
     * @param dsm dsm
     * @param request request
     * @return 直投页的url
     */
    String getPageUrl(Long slotId, String dsm, HttpServletRequest request);
}