package com.duiba.tuia.youtui.web.service;

import com.duiba.tuia.youtui.web.model.UserAccount;

import java.util.Map;

/**
 * 处理定制需求埋点的service
 *
 * @author lichao 2018/3/29
 */
public interface CustomizedEmbedService {

    /**
     * 构建定制直投页传奇皮肤的埋点信息
     *
     * @param dsm      旧dsm
     * @param consumer 账户
     * @param host     host
     * @return 埋点信息
     */
    Map<String, String> buildChuanqiEmbed(Long pageId, String dsm, UserAccount consumer, String host);

    /**
     * @param pageId   页面ID
     * @param times    第几局
     * @param dsm      页面DSM
     * @param consumer 账户
     * @param host
     * @return
     */
    Map<String, String> buildFindDiffEmbed(Long pageId, Long times, String dsm, UserAccount consumer, String host);
}
