
/**
 * Project Name:tuia-youtui-web<br>
 * File Name:ConsumerBo.java<br>
 * Package Name:com.duiba.tuia.youtui.web.bo<br>
 * Date:2017年1月22日上午9:55:06<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 *
 */

package com.duiba.tuia.youtui.web.service;

import cn.com.duiba.tuia.activity.center.api.constant.BalanceType;
import cn.com.duiba.tuia.activity.center.api.dto.NickNameDto;
import cn.com.duiba.tuia.activity.center.api.dto.consumer.ConsumerCache;
import cn.com.duiba.tuia.activity.center.api.dto.consumer.ConsumerDto;
import com.duiba.tuia.youtui.web.exception.ActivityException;
import com.duiba.tuia.youtui.web.model.CommonLoginReq;
import com.duiba.tuia.youtui.web.model.UserAccount;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;


/**
 * ClassName: ConsumerBo <br/>
 * Function: 用户. <br/>
 * date: 2017年1月22日 上午9:55:06 <br/>
 *
 * @author leiliang
 * @version 
 * @since JDK 1.6
 */
public interface ConsumerService {

    /**
     * get Or Make user.
     *
     * @param appId the app id
     * @param partnerUserId the partner user id
     * @return the map< string, object>
     * @throws ActivityException the activity exception
     */
    UserAccount getOrMakeUser(Long appId, String partnerUserId) throws ActivityException;

    /***
         * @Description: checkConsumer 查询正式用户
     * true = 用户存在
     * false = 用户不存在
         *
         * @Param: [appId, phone] 
         * @Return: boolean 
         * @throws:  
         * @author: youhaijun
         * @Date:   2017/12/13
         */
    ConsumerDto findFormalConsumer(Long appId, String phone, String muId);

    /***
         * @Description: findCasualConsumer 查询临时用户
         *
         * @Param: [appId, deviceId]
         * @Return: java.lang.Long
         * @throws:
         * @author: youhaijun
         * @Date:   2017/12/20
         */
    Long findCasualConsumer(Long appId, String deviceId);

    String getRegisterVerCode(String phone);

    void setRegisterVerCode(String phone, String verCode) throws UnsupportedEncodingException, NoSuchAlgorithmException;

    boolean isYiDunVerifyList(String userId);

    void setConsumerCache(ConsumerCache cache);

    ConsumerCache getConsumerCache(Long userId);

    ConsumerCache getConsumerCache4WX(String openId);

    void setTodayFirstGive(String userId, Long amount);

    boolean isFirstGive(Long userId, BalanceType balanceType);

    boolean isTodayFirstGive(String userId);

    void setYiDunVerifyList(String userId);

    int getSmsTimes(String key);

    void setSmsTimes(String key, int times);

    int getSmsTotalTimes();

    void setSmsTotalTimes(int times) throws UnsupportedEncodingException, NoSuchAlgorithmException;

    void updateLoginTryTimes(String userId);

    int getLoginTryTimes(String userId);

    ConsumerDto getOrCreateConsumer(ConsumerDto req) throws ActivityException;

    String getVisitorNickName(int length, int zero);

    boolean updateConsumer(ConsumerDto req) throws ActivityException;

    ConsumerDto getConsumerById(Long userId);

    NickNameDto getNextNickName(Long id);

    boolean confirmNickName(String nickName);

}

