/**
 * Project Name:tuia-youtui-web<br>
 * File Name:BaseService.java<br>
 * Package Name:com.duiba.tuia.youtui.web.service<br>
 * Date:2017年1月22日上午9:59:51<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */

package com.duiba.tuia.youtui.web.service;

import cn.com.duiba.tuia.activity.center.api.common.BaseDto;
import com.duiba.tuia.youtui.web.constant.ErrorCode;
import com.duiba.tuia.youtui.web.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * ClassName: BaseService <br/>
 * Function: 广告服务. <br/>
 * date: 2017年1月22日 上午9:59:51 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class BaseService {

    protected Logger logger = LoggerFactory.getLogger(getClass());

    public <T extends BaseDto> T filterNull(T t, ErrorCode errorCode) throws BusinessException {
        if (BaseDto.isEmpty(t)) {
            throw new BusinessException(errorCode);
        }
        return t;
    }
}
