/**
 * Project Name:tuia-youtui-web<br>
 * File Name:BaseCacheService.java<br>
 * Package Name:com.duiba.tuia.youtui.web.service<br>
 * Date:2017年1月22日下午4:08:48<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */

package com.duiba.tuia.youtui.web.service;

import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import com.duiba.tuia.youtui.web.tool.CachedKeyUtils;
import javax.annotation.Resource;
import org.apache.commons.lang.math.RandomUtils;
import org.joda.time.DateTime;
import org.joda.time.Seconds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;


/**
 * ClassName: BaseCacheService <br/>
 * Function: 缓存基础服务. <br/>
 * date: 2017年1月22日 下午4:08:48 <br/>
 *
 * @author leiliang
 * @since JDK 1.6
 */
@Service
public class BaseCacheService extends BaseService {

    /**
     * 3s.
     */
    protected static final int THREE_SECOND = 3;

    /**
     * 三十分钟.
     */
    protected static final int THIRTY_MIN = 30;

    /**
     * 1分钟.
     */
    protected static final int ONE_MIN = 60;

    /**
     * 5分钟.
     */
    protected static final int FIVE_MIN = 300;

    /**
     * 一小时.
     */
    protected static final int ONE_HOUR = 3600;

    /**
     * 一天.
     */
    protected static final int ONE_DAY = 60 * 60 * 24;

    /**
     * 一周.
     */
    protected static final int ONE_WEEK = 60 * 60 * 24 * 7;

    /**
     * 45天.
     */
    protected static final int DAY_OF_45 = 60 * 60 * 24 * 45;

    /**
     * The redis client2.
     */
    @Resource(name = "redisTemplate")
    protected AdvancedCacheClient advancedCacheClient;

    /*更上一个redisclient持有同一个连接*/
    @Resource
    protected StringRedisTemplate stringRedisTemplate;

    /*更上一个redisclient持有同一个连接*/
    @Resource
    protected RedisTemplate redisTemplate;

    @Resource(name = "redisTemplate")
    protected RedisTemplate<String,Long> slotRedis;

    /**
     * The redis template03.
     */
    @Resource(name = "redisTemplate03")
    protected StringRedisTemplate redisTemplate03;

    /**
     * The cached key utils.
     */
    @Autowired
    protected CachedKeyUtils cachedKeyUtils;

    /**
     * 获取当天剩余秒数+小于7200s的随机时间.
     *
     * @return the rest seconds today
     */
    protected int getRestSecondsToday() {
        return Seconds.secondsBetween(new DateTime(), new DateTime().secondOfDay().withMaximumValue()).getSeconds() + RandomUtils.nextInt(7200);
    }

    /**
     * 获取此时到第二天2:00-5:00 随机时间点的秒数
     * 这段时间系统访问量最低，日失效的redis 可选择在这个时间段失效
     *
     * 推荐指数：★★★★★
     */
    protected int getTomorrowCalmTimeRestSeconds() {
        DateTime now = DateTime.now();
        return Seconds.secondsBetween(now, now.secondOfDay().withMaximumValue()).getSeconds() + 7200 + RandomUtils.nextInt(10800);
    }

    /**
     * 获取到 下周 访问低点 剩余秒数
     */
    protected int getNextWeekCalmTimeRestSeconds() {
        DateTime now = DateTime.now();
        return (7 - now.getDayOfWeek()) * 86400 + Seconds.secondsBetween(now, now.secondOfDay().withMaximumValue()).getSeconds() + 7200 + RandomUtils.nextInt(10800);
    }

}
