package com.duiba.tuia.youtui.web.service;

import cn.com.duiba.tuia.activity.center.api.constant.BalanceType;
import java.util.List;

import cn.com.duiba.tuia.activity.center.api.dto.consumer.BalanceRecordDto;
import com.duiba.tuia.youtui.web.model.BalanceRecordVO;
import com.duiba.tuia.youtui.web.model.req.BalanceRecordQuery;
import com.duiba.tuia.youtui.web.model.rsp.PageBalanceRecord;
import javax.servlet.http.HttpServletRequest;


public interface BalanceRecordService {

    /**
     * 根据用户信息获取记录列表
     * 
     * @param query 查询对象
     * @return 记录列表
     */
    PageBalanceRecord pageQuery(BalanceRecordQuery query, HttpServletRequest request);

    /**
     * 最近的余额记录列表
     * 
     * @param size 获取的条数
     * @return 最近记录列表
     */
    List<BalanceRecordVO> recentlyList(Integer size);

    /**
     * 放入到最近余额记录列表
     * 
     * @param vo 记录
     * @param size 要保存的记录列表
     */
    void putInRecentlyList(BalanceRecordVO vo, Integer size);

    Boolean moveBalance(Long srcUserId, Long destUserId, BalanceType balanceType);

    BalanceRecordDto getCreditsConsumeRecord(Long userId, String orderId, String duibaOrderNUm);
}
