
/**
 * Project Name:tuia-youtui-web<br>
 * File Name:ActivityEngineService.java<br>
 * Package Name:com.duiba.tuia.youtui.web.service<br>
 * Date:2017年4月14日上午11:39:47<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */

package com.duiba.tuia.youtui.web.service;

import cn.com.duiba.tuia.ssp.center.api.dto.RspActivityCenterDto;
import com.duiba.tuia.youtui.web.exception.ActivityException;

import java.util.List;


/**
 * ClassName: ActivityEngineService <br/>
 * 该类主要用于从活动引擎获取推荐活动及引导页
 * date: 2017年4月14日 上午11:39:47 <br/>.
 *
 * @author youhaijun
 * @version
 * @since JDK 1.7
 */
public interface ActivityEngineService {

    /**
     * 获取spm值最高的活动及引导页ID列表.
     *
     * @param slotId the num
     * @return the ids by spm
     * @throws ActivityException the activity exception
     */
    List<Long> getIdsBySpm(Long slotId) throws ActivityException;

    /**
     * 获取推广计划id最大的页面id列表.
     *
     * @param source 1：活动 2：引导页
     * @param slotId
     * @return the new ids
     * @throws ActivityException the activity exception
     */
    List<Long> getNewIds(Integer source, Long slotId) throws ActivityException;

    /**
     * 过滤当前活动列表在广告位是否可用
     *
     * @param actIds
     * @param slotId
     * @return
     */
    List<Long> getCanUseActIds(List<Long> actIds, Long slotId);

    /**
     * @Description: getActCenterList 获取活动中心活动列表
     * 根据广告位id请求ssp-center 获取推荐的或殴打那个中心活动id列表
     * @Param: [slotId]
     * @Return: java.util.List<Long>
     * @throws:
     * @author: youhaijun
     * @Date: 2017/6/6
     */
    List<RspActivityCenterDto> getActCenterList(Long slotId) throws ActivityException;


    /**
         * @Description: getAppEarn 获取媒体分时段收益
         *
         * @Param: [appId]
         * @Return: int
         * @throws:
         * @author: youhaijun
         * @Date:   2017/7/12
         */
    int getAppEarn(Long appId);

    /**
         * @Description: getActivityByUVLaunch 按活动每uv发券推荐活动
         *
         * @Param: [slotId] 
         * @Return: java.util.List<java.lang.Long> 
         * @throws:
         * @author: youhaijun
         * @Date:   2017/7/13
         */
    List<Long> getActivityByUVLaunch(Long slotId) throws ActivityException;

    List<Long> getAvailMainMeet(Long slotId)throws ActivityException;

    List<Long> getDirectedAppByAct(Long activityId);

    /** 获取特殊媒体列表*/
    List<Long> getSpeApp();
}

