/**
 * Project Name:tuia-youtui-web<br>
 * File Name:RecommendRsp.java<br>
 * Package Name:com.duiba.tuia.youtui.web.model.rsp<br>
 * Date:2017年4月13日下午4:59:48<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */

package com.duiba.tuia.youtui.web.model.rsp;

import com.duiba.tuia.youtui.web.biz.interfaces.ImageBusiness;
import com.duiba.tuia.youtui.web.model.AdBlockDto;
import com.duiba.tuia.youtui.web.tool.DomainUtil;

import java.io.Serializable;

/**
 * 谢谢参与推荐返回
 * ClassName: ThanksRecommendRsp <br/>
 * date: 2017年4月13日 下午4:59:48 <br/>
 *
 * @author cdm
 * @since JDK 1.7
 */
public class ThanksRecommendRsp implements Serializable, ImageBusiness {

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = -9083183718100260137L;

    private AdBlockDto block1;

    private AdBlockDto block2;

    private AdBlockDto block3;


    public AdBlockDto getBlock1() {
        return block1;
    }

    public void setBlock1(AdBlockDto block1) {
        this.block1 = block1;
    }

    public AdBlockDto getBlock2() {
        return block2;
    }

    public void setBlock2(AdBlockDto block2) {
        this.block2 = block2;
    }

    public AdBlockDto getBlock3() {
        return block3;
    }

    public void setBlock3(AdBlockDto block3) {
        this.block3 = block3;
    }

    @Override
    public void replaceDomain(String domain) {
        if (block1 != null) {
            block1.setBannerUrl(DomainUtil.replaceDomain(block1.getBannerUrl(), domain));
        }
        if (block2 != null) {
            block2.setBannerUrl(DomainUtil.replaceDomain(block2.getBannerUrl(), domain));
        }

    }
}
