package com.duiba.tuia.youtui.web.model.rsp;

import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;

/**
 * 瓜分红包-获取红包响应
 *
 * @author lichao 2018/3/13
 */
public class RedPacketInfoRsp implements Serializable {

    //当前时间
    @ApiModelProperty(value = "当前时间")
    private String currentTime;

    //活动到期时间
    @ApiModelProperty(value = "活动到期时间")
    private String limitTime;

    //我的红包数量
    @ApiModelProperty(value = "我的红包数量")
    private int packetNum;

    //已抢到的红包总量
    @ApiModelProperty(value = "已抢到的红包总量")
    private long total;

    //抢红包的最多数
    @ApiModelProperty(value = "抢红包的最多数")
    private int max;

    //是否登录
    @ApiModelProperty(value = "是否登录")
    private boolean isLogin;

    //登录后的手机号
    @ApiModelProperty(value = "登录后的手机号")
    private String phone;

    //返回按钮
    @ApiModelProperty(value = "返回按钮")
    private String linkUrl;

    // 埋点信息
    private Map<String,String> stEmbedInfo;

    public String getCurrentTime() {
        return currentTime;
    }

    public void setCurrentTime(String currentTime) {
        this.currentTime = currentTime;
    }

    public String getLimitTime() {
        return limitTime;
    }

    public void setLimitTime(String limitTime) {
        this.limitTime = limitTime;
    }

    public int getPacketNum() {
        return packetNum;
    }

    public void setPacketNum(int packetNum) {
        this.packetNum = packetNum;
    }

    public long getTotal() {
        return total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public int getMax() {
        return max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public boolean isLogin() {
        return isLogin;
    }

    public void setLogin(boolean login) {
        isLogin = login;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Map<String, String> getStEmbedInfo() {
        return stEmbedInfo;
    }

    public void setStEmbedInfo(Map<String, String> stEmbedInfo) {
        this.stEmbedInfo = stEmbedInfo;
    }

    public String getLinkUrl() {
        return linkUrl;
    }

    public void setLinkUrl(String linkUrl) {
        this.linkUrl = linkUrl;
    }
}
