package com.duiba.tuia.youtui.web.model.rsp;

import cn.com.duiba.tuia.activity.center.api.common.PageDto;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * Created by xuefeng on 2017/11/24.
 */
public class PrizeRecordsRsp<T extends Serializable> extends PageDto<T> implements Serializable {

    private static final long serialVersionUID = 1L;

    private ContactInfo contactInfo;

    private Map<String, String> embedData;

    public PrizeRecordsRsp(int totalAmount, List<T> list, int offset, int max) {
        super(totalAmount, list, offset, max);
    }

    public PrizeRecordsRsp(int currentPage, int pageSize) {
        super(currentPage, pageSize);
    }

    public ContactInfo getContactInfo() {
        return contactInfo;
    }

    public void setContactInfo(ContactInfo contactInfo) {
        this.contactInfo = contactInfo;
    }

    public Map<String, String> getEmbedData() {
        return embedData;
    }

    public void setEmbedData(Map<String, String> embedData) {
        this.embedData = embedData;
    }

    public ContactInfo createContactInfo() {
        this.contactInfo =  new ContactInfo();
        return this.contactInfo;
    }

    public class ContactInfo implements Serializable {
        private static final long serialVersionUID = -7402632462602700285L;

        /** 是否展示我的奖品页-客服信息 0:关闭 1:打开", required = false */
        private Boolean             isOpenMineOption;
        /** 是否展示我的奖品页-在线客服 0:关闭 1:打开", required = false */
        private Boolean             isOpenMineOnline;
        /** 我的奖品页客服电话", required = false */
        private String              mineOptionPhone;
        /** "我的奖品页客服qq", required = false */
        private Long                mineOptionQq;

        public Boolean getIsOpenMineOption() {
            return isOpenMineOption;
        }

        public void setIsOpenMineOption(Boolean isOpenMineOption) {
            this.isOpenMineOption = isOpenMineOption;
        }

        public Boolean getIsOpenMineOnline() {
            return isOpenMineOnline;
        }

        public void setIsOpenMineOnline(Boolean isOpenMineOption) {
            this.isOpenMineOnline = isOpenMineOption;
        }

        public String getMineOptionPhone() {
            return mineOptionPhone;
        }

        public void setMineOptionPhone(String mineOptionPhone) {
            this.mineOptionPhone = mineOptionPhone;
        }

        public Long getMineOptionQq() {
            return mineOptionQq;
        }

        public void setMineOptionQq(Long mineOptionQq) {
            this.mineOptionQq = mineOptionQq;
        }
    }
}
